/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.auth.common;

import com.google.common.collect.Sets;
import java.security.Principal;
import java.util.HashSet;
import org.fcrepo.auth.common.FedoraAuthorizationDelegate;
import org.modeshape.jcr.security.AdvancedAuthorizationProvider;
import org.modeshape.jcr.security.SecurityContext;
import org.modeshape.jcr.value.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FedoraUserSecurityContext
implements SecurityContext,
AdvancedAuthorizationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(FedoraUserSecurityContext.class);
    private Principal userPrincipal = null;
    private FedoraAuthorizationDelegate fad = null;
    private boolean loggedIn = true;

    protected FedoraUserSecurityContext(Principal userPrincipal, FedoraAuthorizationDelegate fad) {
        this.fad = fad;
        this.userPrincipal = userPrincipal;
        if (this.fad == null) {
            LOGGER.warn("This security context must have a FAD injected");
            throw new IllegalArgumentException("This security context must have a FAD injected");
        }
    }

    public boolean isAnonymous() {
        return this.userPrincipal == null;
    }

    public final String getUserName() {
        return this.getEffectiveUserPrincipal().getName();
    }

    public final boolean hasRole(String roleName) {
        if ("read".equals(roleName)) {
            return true;
        }
        if ("write".equals(roleName)) {
            return true;
        }
        return "admin".equals(roleName);
    }

    public Principal getEffectiveUserPrincipal() {
        if (this.loggedIn && this.userPrincipal != null) {
            return this.userPrincipal;
        }
        return this.fad.getEveryonePrincipal();
    }

    public void logout() {
        this.loggedIn = false;
    }

    public boolean hasPermission(AdvancedAuthorizationProvider.Context context, Path absPath, String ... actions) {
        Path path;
        if (!this.loggedIn) {
            return false;
        }
        if (absPath == null) {
            if (actions.length == 1 && "read".equals(actions[0])) {
                return true;
            }
            HashSet filteredActions = Sets.newHashSet((Object[])actions);
            filteredActions.remove("register_namespace");
            filteredActions.remove("register_type");
            return filteredActions.isEmpty();
        }
        if (null != absPath.getLastSegment() && absPath.getLastSegment().getString().equals("jcr:content")) {
            path = absPath.subpath(0, absPath.size() - 1);
            LOGGER.debug("..new path to be verified: {}", (Object)path);
        } else {
            path = absPath;
        }
        if (this.fad != null) {
            return this.fad.hasPermission(context.getSession(), path, actions);
        }
        return false;
    }
}

