/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.auth.common;

import java.io.IOException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.fcrepo.auth.common.PrincipalProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractPrincipalProvider
implements PrincipalProvider {
    private static final Logger log = LoggerFactory.getLogger(AbstractPrincipalProvider.class);
    private static final String REALM_NAME = "org.fcrepo.auth.webac.WebACAuthorizingRealm";

    AbstractPrincipalProvider() {
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest hsRequest = (HttpServletRequest)request;
        Subject currentUser = SecurityUtils.getSubject();
        PrincipalCollection principals = currentUser.getPrincipals();
        Set<Principal> newPrincipals = this.getPrincipals(hsRequest);
        if (newPrincipals.size() > 0) {
            Set<Principal> currentPrincipals;
            if (principals == null || principals.asList().isEmpty()) {
                log.debug("Shiro Principal object is not found!");
                currentPrincipals = newPrincipals;
            } else {
                currentPrincipals = new HashSet<Principal>(principals.asSet());
                log.debug("Number of Principals already in session object: {}", (Object)currentPrincipals.size());
                currentPrincipals.addAll(newPrincipals);
            }
            log.debug("Number of Principals after processing the current request: {}", (Object)currentPrincipals.size());
            principals = new SimplePrincipalCollection(currentPrincipals, REALM_NAME);
            currentUser.runAs(principals);
        } else {
            log.debug("New Principals not found in the request!");
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

