/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.auth.common;

import java.util.Set;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.realm.AuthenticatingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.fcrepo.auth.common.ContainerAuthToken;
import org.fcrepo.auth.common.ContainerRolesPrincipalProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletContainerAuthenticatingRealm
extends AuthenticatingRealm {
    private static final Logger log = LoggerFactory.getLogger(ServletContainerAuthenticatingRealm.class);

    public String getName() {
        return "servlet container authentication";
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        ContainerAuthToken authToken = (ContainerAuthToken)token;
        SimplePrincipalCollection principals = new SimplePrincipalCollection();
        log.debug("Creating principals from servlet container principal and roles");
        principals.add(authToken.getPrincipal(), this.getName());
        Set<ContainerRolesPrincipalProvider.ContainerRolesPrincipal> roles = authToken.getRoles();
        if (!roles.isEmpty()) {
            principals.addAll(roles, this.getName());
        }
        return new SimpleAuthenticationInfo((PrincipalCollection)principals, (Object)"AUTHORIZED");
    }

    public boolean supports(AuthenticationToken token) {
        return token instanceof ContainerAuthToken;
    }
}

