/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.auth.common;

import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.fcrepo.auth.common.AbstractPrincipalProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerRolesPrincipalProvider
extends AbstractPrincipalProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContainerRolesPrincipalProvider.class);
    private Set<String> roleNames;

    public void setRoleNames(Set<String> roleNames) {
        this.roleNames = roleNames;
    }

    @Override
    public Set<Principal> getPrincipals(HttpServletRequest request) {
        LOGGER.debug("Checking for principals using {}", (Object)ContainerRolesPrincipalProvider.class.getSimpleName());
        if (request == null) {
            LOGGER.debug("Servlet request was null");
            return Collections.emptySet();
        }
        if (this.roleNames == null) {
            LOGGER.debug("Role names Set was never initialized");
            return Collections.emptySet();
        }
        Iterator<String> iterator = this.roleNames.iterator();
        HashSet<Principal> principals = new HashSet<Principal>();
        while (iterator.hasNext()) {
            String role = iterator.next().trim();
            if (!request.isUserInRole(role)) continue;
            LOGGER.debug("Adding container role as principal: {}", (Object)role);
            principals.add(new ContainerRolesPrincipal(role));
        }
        return principals;
    }

    public static class ContainerRolesPrincipal
    implements Principal {
        private final String name;

        public ContainerRolesPrincipal(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String toString() {
            return this.name;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof ContainerRolesPrincipal) {
                return ((ContainerRolesPrincipal)o).getName().equals(this.getName());
            }
            return false;
        }

        @Override
        public int hashCode() {
            if (this.name == null) {
                return 0;
            }
            return this.name.hashCode();
        }
    }
}

