/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.auth.common;

import org.apache.http.auth.BasicUserPrincipal;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.modeshape.jcr.security.SecurityContext;

public class ShiroSecurityContext
implements SecurityContext {
    private Subject user;
    private String userName;

    public ShiroSecurityContext(Subject user) {
        if (user != null) {
            this.user = user;
            PrincipalCollection principals = user.getPrincipals();
            if (principals != null) {
                BasicUserPrincipal userPrincipal = (BasicUserPrincipal)principals.oneByType(BasicUserPrincipal.class);
                this.userName = userPrincipal != null ? userPrincipal.getName() : null;
            }
        }
    }

    public boolean isAnonymous() {
        return !this.user.isAuthenticated();
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean hasRole(String roleName) {
        if ("read".equals(roleName)) {
            return true;
        }
        if ("write".equals(roleName)) {
            return true;
        }
        return "admin".equals(roleName);
    }

    public void logout() {
    }
}

