/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.auth.common;

import java.util.HashSet;
import java.util.Set;
import org.apache.http.auth.BasicUserPrincipal;
import org.apache.shiro.authc.AuthenticationToken;
import org.fcrepo.auth.common.ContainerRolesPrincipalProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerAuthToken
implements AuthenticationToken {
    private static final Logger log = LoggerFactory.getLogger(ContainerAuthToken.class);
    public static final String AUTHORIZED = "AUTHORIZED";
    private final BasicUserPrincipal servletUser;
    private final Set<ContainerRolesPrincipalProvider.ContainerRolesPrincipal> servletRoles;

    public ContainerAuthToken(String servletUsername, Set<String> servletRoleNames) {
        this.servletUser = new BasicUserPrincipal(servletUsername);
        log.debug("Setting servlet username {}", (Object)servletUsername);
        this.servletRoles = new HashSet<ContainerRolesPrincipalProvider.ContainerRolesPrincipal>();
        for (String roleName : servletRoleNames) {
            log.debug("Adding servlet role {} to {}", (Object)roleName, (Object)servletUsername);
            this.servletRoles.add(new ContainerRolesPrincipalProvider.ContainerRolesPrincipal(roleName));
        }
    }

    public Object getPrincipal() {
        return this.servletUser;
    }

    public Object getCredentials() {
        return AUTHORIZED;
    }

    public Set<ContainerRolesPrincipalProvider.ContainerRolesPrincipal> getRoles() {
        return this.servletRoles;
    }
}

