/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.auth.common;

import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.fcrepo.auth.common.AbstractPrincipalProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpHeaderPrincipalProvider
extends AbstractPrincipalProvider {
    private String headerName;
    private String separator = "";
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpHeaderPrincipalProvider.class);

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    @Override
    public Set<Principal> getPrincipals(HttpServletRequest request) {
        LOGGER.debug("Checking for principals using {}", (Object)HttpHeaderPrincipalProvider.class.getSimpleName());
        if (this.headerName == null || this.separator == null) {
            LOGGER.debug("headerName or separator not initialized");
            return Collections.emptySet();
        }
        LOGGER.debug("Trying to get principals from header: {}; separator: {}", (Object)this.headerName, (Object)this.separator);
        if (request == null) {
            LOGGER.debug("Servlet request from servletCredentials was null");
            return Collections.emptySet();
        }
        String value = request.getHeader(this.headerName);
        if (value == null) {
            LOGGER.debug("Value for header {} is null", (Object)this.headerName);
            return Collections.emptySet();
        }
        String[] names = value.split(this.separator);
        HashSet<Principal> principals = new HashSet<Principal>();
        for (String name : names) {
            LOGGER.debug("Adding HTTP header-provided principal: {}", (Object)name.trim());
            principals.add(this.createPrincipal(name));
        }
        return principals;
    }

    protected Principal createPrincipal(String name) {
        return new HttpHeaderPrincipal(name.trim());
    }

    public static class HttpHeaderPrincipal
    implements Principal {
        private final String name;

        protected HttpHeaderPrincipal(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String toString() {
            return this.name;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof HttpHeaderPrincipal) {
                return ((HttpHeaderPrincipal)o).getName().equals(this.getName());
            }
            return false;
        }

        @Override
        public int hashCode() {
            if (this.name == null) {
                return 0;
            }
            return this.name.hashCode();
        }
    }
}

