/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.auth.common;

import java.io.IOException;
import java.security.Principal;
import java.util.HashSet;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.Subject;
import org.fcrepo.auth.common.ContainerAuthToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletContainerAuthFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(ServletContainerAuthFilter.class);
    public static final String FEDORA_ADMIN_ROLE = "fedoraAdmin";
    public static final String FEDORA_USER_ROLE = "fedoraUser";
    private static final String[] ROLE_NAMES = new String[]{"fedoraAdmin", "fedoraUser"};

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        Principal servletUser = httpRequest.getUserPrincipal();
        Subject currentUser = SecurityUtils.getSubject();
        if (servletUser != null) {
            log.debug("There is a servlet user: {}", (Object)servletUser.getName());
            HashSet<String> roles = new HashSet<String>();
            for (String roleName : ROLE_NAMES) {
                log.debug("Testing role {}", (Object)roleName);
                if (!httpRequest.isUserInRole(roleName)) continue;
                log.debug("Servlet user {} has servlet role: {}", (Object)servletUser.getName(), (Object)roleName);
                roles.add(roleName);
            }
            ContainerAuthToken token = new ContainerAuthToken(servletUser.getName(), roles);
            log.debug("Credentials for servletUser = {}", token.getCredentials());
            currentUser.login((AuthenticationToken)token);
        } else {
            log.debug("Anonymous request");
            currentUser.logout();
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

