/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.auth.common;

import java.security.Principal;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.fcrepo.auth.common.HttpHeaderPrincipalProvider;
import org.fcrepo.kernel.api.exception.RepositoryConfigurationException;

public class DelegateHeaderPrincipalProvider
extends HttpHeaderPrincipalProvider {
    private static final String SEP = "no-separator";
    protected static final String DELEGATE_HEADER = "On-Behalf-Of";

    public DelegateHeaderPrincipalProvider() {
        this.setHeaderName(DELEGATE_HEADER);
        this.setSeparator(SEP);
    }

    public Principal getDelegate(HttpServletRequest request) {
        Set<Principal> principals = this.getPrincipals(request);
        if (principals.size() == 0) {
            return null;
        }
        if (principals.size() == 1) {
            return principals.iterator().next();
        }
        throw new RepositoryConfigurationException("Too many delegates! " + principals);
    }

    @Override
    protected Principal createPrincipal(String name) {
        return new DelegatedHeaderPrincipal(name.trim());
    }

    public static class DelegatedHeaderPrincipal
    implements Principal {
        private final String name;

        protected DelegatedHeaderPrincipal(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String toString() {
            return this.name;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof DelegatedHeaderPrincipal) {
                return ((DelegatedHeaderPrincipal)o).getName().equals(this.getName());
            }
            return false;
        }

        @Override
        public int hashCode() {
            if (this.name == null) {
                return 0;
            }
            return this.name.hashCode();
        }
    }
}

