/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.auth.webac;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.modify.request.UpdateDataDelete;
import org.apache.jena.sparql.modify.request.UpdateModify;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.fcrepo.auth.webac.CachedSparqlRequest;
import org.fcrepo.auth.webac.URIConstants;
import org.fcrepo.auth.webac.WebACAuthorizingRealm;
import org.fcrepo.auth.webac.WebACPermission;
import org.fcrepo.http.api.FedoraLdp;
import org.fcrepo.http.commons.api.rdf.HttpResourceConverter;
import org.fcrepo.http.commons.session.HttpSession;
import org.fcrepo.http.commons.session.SessionFactory;
import org.fcrepo.kernel.api.FedoraSession;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.fcrepo.kernel.api.services.NodeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebACFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(WebACFilter.class);
    private static final MediaType sparqlUpdate = MediaType.valueOf((String)"application/sparql-update");
    private FedoraSession session;
    private static final Principal FOAF_AGENT_PRINCIPAL = new Principal(){

        @Override
        public String getName() {
            return "http://xmlns.com/foaf/0.1/Agent";
        }

        @Override
        public String toString() {
            return this.getName();
        }
    };
    private static final PrincipalCollection FOAF_AGENT_PRINCIPAL_COLLECTION = new SimplePrincipalCollection((Object)FOAF_AGENT_PRINCIPAL, WebACAuthorizingRealm.class.getCanonicalName());
    private static Subject FOAF_AGENT_SUBJECT;
    @Inject
    private NodeService nodeService;
    @Inject
    private SessionFactory sessionFactory;

    public void init(FilterConfig filterConfig) {
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        void var5_7;
        Subject currentUser = SecurityUtils.getSubject();
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        if (this.isSparqlUpdate(httpServletRequest)) {
            CachedSparqlRequest cachedSparqlRequest = new CachedSparqlRequest((ServletRequest)httpServletRequest);
        }
        if (currentUser.isAuthenticated()) {
            log.debug("User is authenticated");
            if (currentUser.hasRole("fedoraAdmin")) {
                log.debug("User has fedoraAdmin role");
            } else {
                if (!currentUser.hasRole("fedoraUser")) {
                    log.debug("User has no recognized servlet container role");
                    ((HttpServletResponse)response).sendError(403);
                    return;
                }
                log.debug("User has fedoraUser role");
                if (!this.isAuthorized(currentUser, (HttpServletRequest)var5_7)) {
                    ((HttpServletResponse)response).sendError(403);
                    return;
                }
            }
        } else {
            log.debug("User is NOT authenticated");
            if (!this.isAuthorized(this.getFoafAgentSubject(), (HttpServletRequest)var5_7)) {
                ((HttpServletResponse)response).sendError(403);
                return;
            }
        }
        chain.doFilter((ServletRequest)var5_7, response);
    }

    private Subject getFoafAgentSubject() {
        if (FOAF_AGENT_SUBJECT == null) {
            FOAF_AGENT_SUBJECT = new Subject.Builder().principals(FOAF_AGENT_PRINCIPAL_COLLECTION).buildSubject();
        }
        return FOAF_AGENT_SUBJECT;
    }

    public void destroy() {
    }

    private FedoraSession session() {
        if (this.session == null) {
            this.session = this.sessionFactory.getInternalSession();
        }
        return this.session;
    }

    private String getBaseURL(HttpServletRequest servletRequest) {
        String url;
        String baseURL = url = servletRequest.getRequestURL().toString();
        String pathInfo = servletRequest.getPathInfo();
        if (pathInfo != null) {
            int loc = url.lastIndexOf(pathInfo);
            baseURL = url.substring(0, loc);
        }
        log.debug("Base URL determined from servlet request is {}", (Object)baseURL);
        return baseURL;
    }

    private FedoraResource resource(HttpServletRequest servletRequest) {
        return (FedoraResource)this.nodeService.find(this.session(), this.getRepoPath(servletRequest));
    }

    private boolean resourceExists(HttpServletRequest servletRequest) {
        return this.nodeService.exists(this.session(), this.getRepoPath(servletRequest));
    }

    private String getRepoPath(HttpServletRequest servletRequest) {
        String httpURI = servletRequest.getRequestURL().toString();
        HttpSession httpSession = new HttpSession(this.session());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)this.getBaseURL(servletRequest)).path(FedoraLdp.class);
        HttpResourceConverter conv = new HttpResourceConverter(httpSession, uriBuilder);
        Resource resource = ModelFactory.createDefaultModel().createResource(httpURI);
        String repoPath = conv.asString(resource);
        log.debug("Converted request URI {} to repo path {}", (Object)httpURI, (Object)repoPath);
        return repoPath;
    }

    private boolean isAuthorized(Subject currentUser, HttpServletRequest httpRequest) throws IOException {
        String requestURL = httpRequest.getRequestURL().toString();
        boolean isAcl = requestURL.endsWith("fcr:acl");
        URI requestURI = URI.create(requestURL);
        log.debug("Request URI is {}", (Object)requestURI);
        WebACPermission toRead = new WebACPermission(URIConstants.WEBAC_MODE_READ, requestURI);
        WebACPermission toWrite = new WebACPermission(URIConstants.WEBAC_MODE_WRITE, requestURI);
        WebACPermission toAppend = new WebACPermission(URIConstants.WEBAC_MODE_APPEND, requestURI);
        WebACPermission toControl = new WebACPermission(URIConstants.WEBAC_MODE_CONTROL, requestURI);
        switch (httpRequest.getMethod()) {
            case "OPTIONS": 
            case "HEAD": 
            case "GET": {
                if (isAcl) {
                    if (currentUser.isPermitted((Permission)toControl)) {
                        log.debug("GET allowed by {} permission", (Object)toControl);
                        return true;
                    }
                    log.debug("GET prohibited without {} permission", (Object)toControl);
                    return false;
                }
                return currentUser.isPermitted((Permission)toRead);
            }
            case "PUT": {
                if (isAcl) {
                    if (currentUser.isPermitted((Permission)toControl)) {
                        log.debug("PUT allowed by {} permission", (Object)toControl);
                        return true;
                    }
                    log.debug("PUT prohibited without {} permission", (Object)toControl);
                    return false;
                }
                if (currentUser.isPermitted((Permission)toWrite)) {
                    log.debug("PUT allowed by {} permission", (Object)toWrite);
                    return true;
                }
                if (this.resourceExists(httpRequest)) {
                    log.debug("PUT prohibited to existing resource without {} permission", (Object)toWrite);
                    return false;
                }
                log.debug("Resource doesn't exist; checking parent resources for acl:Append permission");
                if (currentUser.isPermitted((Permission)toAppend)) {
                    log.debug("PUT allowed for new resource by inherited {} permission", (Object)toAppend);
                    return true;
                }
                log.debug("PUT prohibited for new resource without inherited {} permission", (Object)toAppend);
                return false;
            }
            case "POST": {
                if (currentUser.isPermitted((Permission)toWrite)) {
                    log.debug("POST allowed by {} permission", (Object)toWrite);
                    return true;
                }
                if (this.resourceExists(httpRequest)) {
                    if (this.resource(httpRequest).hasType("fedora:Binary")) {
                        log.debug("POST prohibited to binary resource without {} permission", (Object)toWrite);
                        return false;
                    }
                    if (currentUser.isPermitted((Permission)toAppend)) {
                        log.debug("POST allowed to container by {} permission", (Object)toAppend);
                        return true;
                    }
                    log.debug("POST prohibited to container without {} permission", (Object)toAppend);
                    return false;
                }
                log.debug("POST prohibited to non-existent resource without {} permission", (Object)toWrite);
                return false;
            }
            case "DELETE": {
                if (isAcl) {
                    if (currentUser.isPermitted((Permission)toControl)) {
                        log.debug("DELETE allowed by {} permission", (Object)toControl);
                        return true;
                    }
                    log.debug("DELETE prohibited without {} permission", (Object)toControl);
                    return false;
                }
                return currentUser.isPermitted((Permission)toWrite);
            }
            case "PATCH": {
                if (isAcl) {
                    if (currentUser.isPermitted((Permission)toControl)) {
                        log.debug("PATCH allowed by {} permission", (Object)toControl);
                        return true;
                    }
                    log.debug("PATCH prohibited without {} permission", (Object)toControl);
                    return false;
                }
                if (currentUser.isPermitted((Permission)toWrite)) {
                    return true;
                }
                if (currentUser.isPermitted((Permission)toAppend)) {
                    return this.isPatchContentPermitted(httpRequest);
                }
                return false;
            }
        }
        return false;
    }

    private boolean isPatchContentPermitted(HttpServletRequest httpRequest) throws IOException {
        if (!this.isSparqlUpdate(httpRequest)) {
            log.debug("Cannot verify authorization on NON-SPARQL Patch request.");
            return false;
        }
        if (httpRequest.getInputStream() != null) {
            boolean noDeletes = false;
            try {
                noDeletes = !this.hasDeleteClause(IOUtils.toString((InputStream)httpRequest.getInputStream(), (Charset)StandardCharsets.UTF_8));
            }
            catch (QueryParseException ex) {
                log.error("Cannot verify authorization! Exception while inspecting SPARQL query!", (Throwable)ex);
            }
            return noDeletes;
        }
        log.debug("Authorizing SPARQL request with no content.");
        return true;
    }

    private boolean hasDeleteClause(String sparqlString) {
        UpdateRequest sparqlUpdate = UpdateFactory.create((String)sparqlString);
        return sparqlUpdate.getOperations().stream().filter(update -> update instanceof UpdateDataDelete).map(update -> (UpdateDataDelete)update).anyMatch(update -> update.getQuads().size() > 0) || sparqlUpdate.getOperations().stream().filter(update -> update instanceof UpdateModify).peek(update -> log.debug("Inspecting update statement for DELETE clause: {}", (Object)update.toString())).map(update -> (UpdateModify)update).filter(UpdateModify::hasDeleteClause).anyMatch(update -> update.getDeleteQuads().size() > 0);
    }

    private boolean isSparqlUpdate(HttpServletRequest request) {
        try {
            return request.getMethod().equals("PATCH") && sparqlUpdate.isCompatible(MediaType.valueOf((String)request.getContentType()));
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

