/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.auth.webac;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.jcr.RepositoryException;
import org.apache.jena.graph.FrontsTriple;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Resource;
import org.fcrepo.auth.webac.ACLHandle;
import org.fcrepo.auth.webac.WebACAuthorization;
import org.fcrepo.http.api.FedoraAcl;
import org.fcrepo.http.commons.session.SessionFactory;
import org.fcrepo.kernel.api.FedoraSession;
import org.fcrepo.kernel.api.RequiredRdfContext;
import org.fcrepo.kernel.api.TripleCategory;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.api.identifiers.IdentifierConverter;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.fcrepo.kernel.api.services.NodeService;
import org.fcrepo.kernel.modeshape.FedoraSessionImpl;
import org.fcrepo.kernel.modeshape.rdf.impl.DefaultIdentifierTranslator;
import org.fcrepo.kernel.modeshape.utils.FedoraTypesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebACRolesProvider {
    public static final String GROUP_AGENT_BASE_URI_PROPERTY = "fcrepo.auth.webac.groupAgent.baseUri";
    private static final Logger LOGGER = LoggerFactory.getLogger(WebACRolesProvider.class);
    private static final String FEDORA_INTERNAL_PREFIX = "info:fedora";
    private static final String JCR_VERSIONABLE_UUID_PROPERTY = "jcr:versionableUuid";
    private static final Node RDF_TYPE_NODE = NodeFactory.createURI((String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
    private static final Node VCARD_GROUP_NODE = NodeFactory.createURI((String)"http://www.w3.org/2006/vcard/ns#Group");
    private static final Node VCARD_MEMBER_NODE = NodeFactory.createURI((String)"http://www.w3.org/2006/vcard/ns#hasMember");
    @Inject
    private NodeService nodeService;
    @Inject
    private SessionFactory sessionFactory;
    private static final Function<List<String>, Predicate<WebACAuthorization>> accessToClass = uris -> auth -> uris.stream().anyMatch(uri -> auth.getAccessToClassURIs().contains(uri));
    private static final Function<List<String>, Predicate<WebACAuthorization>> accessTo = uris -> auth -> uris.stream().anyMatch(uri -> auth.getAccessToURIs().contains(uri));
    private static final Predicate<Triple> hasAclPredicate = triple -> triple.getPredicate().getNameSpace().equals("http://www.w3.org/ns/auth/acl#");

    public Map<String, Collection<String>> getRoles(javax.jcr.Node node) {
        try {
            return this.getAgentRoles((FedoraResource)this.nodeService.find((FedoraSession)new FedoraSessionImpl(node.getSession()), node.getPath()));
        }
        catch (RepositoryException ex) {
            throw new RepositoryRuntimeException((Throwable)ex);
        }
    }

    private Map<String, Collection<String>> getAgentRoles(FedoraResource resource) {
        LOGGER.debug("Getting agent roles for: {}", (Object)resource.getPath());
        Optional<ACLHandle> effectiveAcl = WebACRolesProvider.getEffectiveAcl(resource, false, this.sessionFactory);
        ArrayList<String> resourcePaths = new ArrayList<String>();
        resourcePaths.add(FEDORA_INTERNAL_PREFIX + resource.getPath());
        List rdfTypes = resource.getTypes();
        effectiveAcl.map(aclHandle -> aclHandle.resource).filter(effectiveResource -> !effectiveResource.getPath().equals(resource.getPath())).ifPresent(effectiveResource -> {
            resourcePaths.add(FEDORA_INTERNAL_PREFIX + effectiveResource.getPath());
            rdfTypes.addAll(effectiveResource.getTypes());
        });
        if (!effectiveAcl.isPresent()) {
            resourcePaths.addAll(WebACRolesProvider.getAllPathAncestors(resource.getPath()));
        }
        Predicate<WebACAuthorization> checkAccessTo = accessTo.apply(resourcePaths);
        Predicate<WebACAuthorization> checkAccessToClass = accessToClass.apply(rdfTypes.stream().map(URI::toString).collect(Collectors.toList()));
        List authorizations = effectiveAcl.map(auth -> auth.authorizations).orElseGet(() -> WebACRolesProvider.getDefaultAuthorizations());
        HashMap<String, Collection<String>> effectiveRoles = new HashMap<String, Collection<String>>();
        authorizations.stream().filter(checkAccessTo.or(checkAccessToClass)).forEach(auth -> {
            Stream.concat(auth.getAgents().stream(), this.dereferenceAgentGroups(auth.getAgentGroups()).stream()).filter(agent -> !agent.equals("http://xmlns.com/foaf/0.1/Agent") && !agent.equals("http://www.w3.org/ns/auth/acl#AuthenticatedAgent")).forEach(agent -> effectiveRoles.computeIfAbsent((String)agent, key -> new HashSet()).addAll(auth.getModes().stream().map(URI::toString).collect(Collectors.toSet())));
            auth.getAgentClasses().stream().filter(agentClass -> agentClass.equals("http://xmlns.com/foaf/0.1/Agent") || agentClass.equals("http://www.w3.org/ns/auth/acl#AuthenticatedAgent")).forEach(agentClass -> effectiveRoles.computeIfAbsent((String)agentClass, key -> new HashSet()).addAll(auth.getModes().stream().map(URI::toString).collect(Collectors.toSet())));
        });
        LOGGER.debug("Unfiltered ACL: {}", effectiveRoles);
        return effectiveRoles;
    }

    private static List<String> getAllPathAncestors(String path) {
        List<String> segments = Arrays.asList(path.split("/"));
        return IntStream.range(1, segments.size()).mapToObj(frameSize -> "info:fedora/" + String.join((CharSequence)"/", segments.subList(1, frameSize))).collect(Collectors.toList());
    }

    private List<String> dereferenceAgentGroups(Collection<String> agentGroups) {
        FedoraSession internalSession = this.sessionFactory.getInternalSession();
        DefaultIdentifierTranslator translator = new DefaultIdentifierTranslator(FedoraSessionImpl.getJcrSession((FedoraSession)internalSession));
        List<String> members = agentGroups.stream().flatMap(arg_0 -> this.lambda$dereferenceAgentGroups$19(internalSession, (IdentifierConverter)translator, arg_0)).collect(Collectors.toList());
        if (LOGGER.isDebugEnabled() && !agentGroups.isEmpty()) {
            LOGGER.debug("Found {} members in {} agentGroups resources", (Object)members.size(), (Object)agentGroups.size());
        }
        return members;
    }

    private static Stream<String> getAgentMembers(IdentifierConverter<Resource, FedoraResource> translator, FedoraResource resource, String hashPortion) {
        List triples = resource.getTriples(translator, (TripleCategory)RequiredRdfContext.PROPERTIES).filter(triple -> hashPortion == null || triple.getSubject().getURI().endsWith(hashPortion)).collect(Collectors.toList());
        boolean hasVcardGroup = triples.stream().anyMatch(triple -> triple.matches(triple.getSubject(), RDF_TYPE_NODE, VCARD_GROUP_NODE));
        if (hasVcardGroup) {
            return triples.stream().filter(triple -> triple.predicateMatches(VCARD_MEMBER_NODE)).map(Triple::getObject).flatMap(WebACRolesProvider::nodeToStringStream).map(WebACRolesProvider::stripUserAgentBaseURI);
        }
        return Stream.empty();
    }

    private static String stripUserAgentBaseURI(String object) {
        String userBaseUri = System.getProperty("fcrepo.auth.webac.userAgent.baseUri");
        if (userBaseUri != null && object.startsWith(userBaseUri)) {
            return object.substring(userBaseUri.length());
        }
        return object;
    }

    private static Stream<String> nodeToStringStream(Node object) {
        if (object.isURI()) {
            return Stream.of(object.getURI());
        }
        if (object.isLiteral()) {
            return Stream.of(object.getLiteralValue().toString());
        }
        return Stream.empty();
    }

    private static List<WebACAuthorization> getAuthorizations(FedoraResource aclResource, boolean ancestorAcl, SessionFactory sessionFactory) {
        FedoraSession internalSession = sessionFactory.getInternalSession();
        ArrayList<WebACAuthorization> authorizations = new ArrayList<WebACAuthorization>();
        DefaultIdentifierTranslator translator = new DefaultIdentifierTranslator(FedoraSessionImpl.getJcrSession((FedoraSession)internalSession));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("ACL: {}", (Object)aclResource.getPath());
        }
        if (aclResource.isAcl()) {
            List triples = (List)aclResource.getTriples((IdentifierConverter)translator, (TripleCategory)RequiredRdfContext.PROPERTIES).collect(Collectors.toList());
            Set authSubjects = triples.stream().filter(t -> t.getPredicate().getURI().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type") && t.getObject().getURI().equals("http://www.w3.org/ns/auth/acl#Authorization")).map(t -> t.getSubject()).collect(Collectors.toSet());
            HashMap authMap = new HashMap();
            triples.stream().filter(hasAclPredicate).forEach(triple -> {
                if (authSubjects.contains(triple.getSubject())) {
                    Map aclTriples = authMap.computeIfAbsent(triple.getSubject().getURI(), key -> new HashMap());
                    String predicate = triple.getPredicate().getURI();
                    List values = aclTriples.computeIfAbsent(predicate, key -> new ArrayList());
                    WebACRolesProvider.nodeToStringStream(triple.getObject()).forEach(values::add);
                    if (predicate.equals("http://www.w3.org/ns/auth/acl#agent")) {
                        WebACRolesProvider.additionalAgentValues(triple.getObject()).forEach(values::add);
                    }
                }
            });
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Adding acl:Authorization from {}", (Object)aclResource.getPath());
            }
            authMap.values().forEach(aclTriples -> {
                WebACAuthorization authorization = WebACRolesProvider.createAuthorizationFromMap(aclTriples);
                if (!ancestorAcl || authorization.getDefaults().size() > 0) {
                    authorizations.add(authorization);
                }
            });
        }
        return authorizations;
    }

    private static WebACAuthorization createAuthorizationFromMap(Map<String, List<String>> data) {
        return new WebACAuthorization(data.getOrDefault("http://www.w3.org/ns/auth/acl#agent", Collections.emptyList()), data.getOrDefault("http://www.w3.org/ns/auth/acl#agentClass", Collections.emptyList()), data.getOrDefault("http://www.w3.org/ns/auth/acl#mode", Collections.emptyList()).stream().map(URI::create).collect(Collectors.toList()), data.getOrDefault("http://www.w3.org/ns/auth/acl#accessTo", Collections.emptyList()), data.getOrDefault("http://www.w3.org/ns/auth/acl#accessToClass", Collections.emptyList()), data.getOrDefault("http://www.w3.org/ns/auth/acl#agentGroup", Collections.emptyList()), data.getOrDefault("http://www.w3.org/ns/auth/acl#default", Collections.emptyList()));
    }

    static Optional<ACLHandle> getEffectiveAcl(FedoraResource resource, boolean ancestorAcl, SessionFactory sessionFactory) {
        try {
            List<WebACAuthorization> authorizations;
            FedoraResource aclResource = resource.getAcl();
            if (aclResource != null && (authorizations = WebACRolesProvider.getAuthorizations(aclResource, ancestorAcl, sessionFactory)).size() > 0) {
                return Optional.of(new ACLHandle(resource, authorizations));
            }
            if (FedoraTypesUtils.getJcrNode((FedoraResource)resource).getDepth() == 0) {
                LOGGER.debug("No ACLs defined on this node or in parent hierarchy");
                return Optional.empty();
            }
            LOGGER.trace("Checking parent resource for ACL. No ACL found at {}", (Object)resource.getPath());
            return WebACRolesProvider.getEffectiveAcl(resource.getContainer(), true, sessionFactory);
        }
        catch (RepositoryException ex) {
            LOGGER.debug("Exception finding effective ACL: {}", (Object)ex.getMessage());
            return Optional.empty();
        }
    }

    private static List<WebACAuthorization> getDefaultAuthorizations() {
        HashMap<String, List<String>> aclTriples = new HashMap<String, List<String>>();
        ArrayList<WebACAuthorization> authorizations = new ArrayList<WebACAuthorization>();
        FedoraAcl.getDefaultAcl(null).listStatements().mapWith(FrontsTriple::asTriple).forEachRemaining(triple -> {
            if (hasAclPredicate.test((Triple)triple)) {
                String predicate = triple.getPredicate().getURI();
                List values = aclTriples.computeIfAbsent(predicate, key -> new ArrayList());
                WebACRolesProvider.nodeToStringStream(triple.getObject()).forEach(values::add);
                if (predicate.equals("http://www.w3.org/ns/auth/acl#agent")) {
                    WebACRolesProvider.additionalAgentValues(triple.getObject()).forEach(values::add);
                }
            }
        });
        authorizations.add(WebACRolesProvider.createAuthorizationFromMap(aclTriples));
        return authorizations;
    }

    private static Stream<String> additionalAgentValues(Node object) {
        String groupBaseUri = System.getProperty(GROUP_AGENT_BASE_URI_PROPERTY);
        String userBaseUri = System.getProperty("fcrepo.auth.webac.userAgent.baseUri");
        if (object.isURI()) {
            String uri = object.getURI();
            if (userBaseUri != null && uri.startsWith(userBaseUri)) {
                return Stream.of(uri.substring(userBaseUri.length()));
            }
            if (groupBaseUri != null && uri.startsWith(groupBaseUri)) {
                return Stream.of(uri.substring(groupBaseUri.length()));
            }
        }
        return Stream.empty();
    }

    private /* synthetic */ Stream lambda$dereferenceAgentGroups$19(FedoraSession internalSession, IdentifierConverter translator, String agentGroup) {
        if (agentGroup.startsWith(FEDORA_INTERNAL_PREFIX)) {
            int hashIndex = agentGroup.indexOf("#");
            String agentGroupNoHash = hashIndex > 0 ? agentGroup.substring(0, hashIndex) : agentGroup;
            String hashedSuffix = hashIndex > 0 ? agentGroup.substring(hashIndex) : null;
            FedoraResource resource = (FedoraResource)this.nodeService.find(internalSession, agentGroupNoHash.substring(FEDORA_INTERNAL_PREFIX.length()));
            return WebACRolesProvider.getAgentMembers((IdentifierConverter<Resource, FedoraResource>)translator, resource, hashedSuffix);
        }
        if (agentGroup.equals("http://xmlns.com/foaf/0.1/Agent")) {
            return Stream.of(agentGroup);
        }
        LOGGER.info("Ignoring agentGroup: {}", (Object)agentGroup);
        return Stream.empty();
    }
}

