/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.auth.webac;

import com.fasterxml.jackson.core.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFReader;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RiotException;
import org.apache.jena.sparql.modify.request.UpdateData;
import org.apache.jena.sparql.modify.request.UpdateDataDelete;
import org.apache.jena.sparql.modify.request.UpdateModify;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.fcrepo.auth.webac.CachedHttpRequest;
import org.fcrepo.auth.webac.URIConstants;
import org.fcrepo.auth.webac.WebACAuthorizingRealm;
import org.fcrepo.auth.webac.WebACPermission;
import org.fcrepo.http.api.FedoraLdp;
import org.fcrepo.http.commons.api.rdf.HttpResourceConverter;
import org.fcrepo.http.commons.session.HttpSession;
import org.fcrepo.http.commons.session.SessionFactory;
import org.fcrepo.kernel.api.FedoraSession;
import org.fcrepo.kernel.api.RdfLexicon;
import org.fcrepo.kernel.api.RequiredRdfContext;
import org.fcrepo.kernel.api.exception.MalformedRdfException;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.api.identifiers.IdentifierConverter;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.fcrepo.kernel.api.services.NodeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebACFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(WebACFilter.class);
    private static final MediaType sparqlUpdate = MediaType.valueOf((String)"application/sparql-update");
    private FedoraSession session;
    private static final Principal FOAF_AGENT_PRINCIPAL = new Principal(){

        @Override
        public String getName() {
            return "http://xmlns.com/foaf/0.1/Agent";
        }

        @Override
        public String toString() {
            return this.getName();
        }
    };
    private static final PrincipalCollection FOAF_AGENT_PRINCIPAL_COLLECTION = new SimplePrincipalCollection((Object)FOAF_AGENT_PRINCIPAL, WebACAuthorizingRealm.class.getCanonicalName());
    private static Subject FOAF_AGENT_SUBJECT;
    @Inject
    private NodeService nodeService;
    @Inject
    private SessionFactory sessionFactory;
    private static Set<URI> directOrIndirect;
    private static Set<String> rdfContentTypes;

    public void init(FilterConfig filterConfig) {
    }

    private void addURIToAuthorize(HttpServletRequest httpRequest, URI uri) {
        HashSet<URI> targetURIs = (HashSet<URI>)httpRequest.getAttribute("URIS_TO_AUTHORIZE");
        if (targetURIs == null) {
            targetURIs = new HashSet<URI>();
            httpRequest.setAttribute("URIS_TO_AUTHORIZE", targetURIs);
        }
        targetURIs.add(uri);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        void var5_7;
        Subject currentUser = SecurityUtils.getSubject();
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        if (this.isSparqlUpdate(httpServletRequest) || this.isRdfRequest(httpServletRequest)) {
            CachedHttpRequest cachedHttpRequest = new CachedHttpRequest((ServletRequest)httpServletRequest);
        }
        if (this.hasEmptyPathSegments((HttpServletRequest)var5_7)) {
            ((HttpServletResponse)response).sendError(400, String.format("Path contains empty element! %s", var5_7.getRequestURI()));
            return;
        }
        this.addURIToAuthorize((HttpServletRequest)var5_7, URI.create(var5_7.getRequestURL().toString()));
        if (currentUser.isAuthenticated()) {
            log.debug("User is authenticated");
            if (currentUser.hasRole("fedoraAdmin")) {
                log.debug("User has fedoraAdmin role");
            } else {
                if (!currentUser.hasRole("fedoraUser")) {
                    log.debug("User has no recognized servlet container role");
                    ((HttpServletResponse)response).sendError(403);
                    return;
                }
                log.debug("User has fedoraUser role");
                if (!this.isAuthorized(currentUser, (HttpServletRequest)var5_7)) {
                    ((HttpServletResponse)response).sendError(403);
                    return;
                }
            }
        } else {
            log.debug("User is NOT authenticated");
            if (!this.isAuthorized(this.getFoafAgentSubject(), (HttpServletRequest)var5_7)) {
                ((HttpServletResponse)response).sendError(403);
                return;
            }
        }
        chain.doFilter((ServletRequest)var5_7, response);
    }

    private Subject getFoafAgentSubject() {
        if (FOAF_AGENT_SUBJECT == null) {
            FOAF_AGENT_SUBJECT = new Subject.Builder().principals(FOAF_AGENT_PRINCIPAL_COLLECTION).buildSubject();
        }
        return FOAF_AGENT_SUBJECT;
    }

    public void destroy() {
    }

    private FedoraSession session() {
        if (this.session == null) {
            this.session = this.sessionFactory.getInternalSession();
        }
        return this.session;
    }

    private boolean hasEmptyPathSegments(HttpServletRequest httpRequest) {
        String requestPath = httpRequest.getContextPath() + httpRequest.getServletPath() + httpRequest.getRequestURI();
        String finalTestPath = requestPath.startsWith("/") && requestPath.endsWith("/") && requestPath.length() > 1 ? requestPath.substring(1, requestPath.length() - 1) : (requestPath.startsWith("/") ? requestPath.substring(1) : (requestPath.endsWith("/") ? requestPath.substring(0, requestPath.length() - 1) : requestPath));
        if (finalTestPath.contains("/")) {
            String[] paths = finalTestPath.split("/", -1);
            return Arrays.stream(paths).anyMatch(String::isEmpty);
        }
        return false;
    }

    private String getBaseURL(HttpServletRequest servletRequest) {
        String url;
        String baseURL = url = servletRequest.getRequestURL().toString();
        String pathInfo = servletRequest.getPathInfo();
        if (pathInfo != null) {
            int loc = url.lastIndexOf(pathInfo);
            baseURL = url.substring(0, loc);
        }
        log.debug("Base URL determined from servlet request is {}", (Object)baseURL);
        return baseURL;
    }

    private String getContainerUrl(HttpServletRequest servletRequest) {
        String pathInfo = servletRequest.getPathInfo();
        String baseUrl = servletRequest.getRequestURL().toString().replace(pathInfo, "");
        String[] paths = pathInfo.split("/");
        CharSequence[] parentPaths = Arrays.copyOfRange(paths, 0, paths.length - 1);
        return baseUrl + String.join((CharSequence)"/", parentPaths);
    }

    private boolean containerExists(HttpServletRequest servletRequest) {
        if (this.resourceExists(servletRequest)) {
            return true;
        }
        String parentURI = this.getContainerUrl(servletRequest);
        return this.nodeService.exists(this.session(), this.getRepoPath(servletRequest, parentURI));
    }

    private FedoraResource getContainer(HttpServletRequest servletRequest) {
        if (this.resourceExists(servletRequest)) {
            return this.resource(servletRequest).getContainer();
        }
        String parentURI = this.getContainerUrl(servletRequest);
        return (FedoraResource)this.nodeService.find(this.session(), this.getRepoPath(servletRequest, parentURI));
    }

    private FedoraResource resource(HttpServletRequest servletRequest) {
        return (FedoraResource)this.nodeService.find(this.session(), this.getRepoPath(servletRequest));
    }

    private boolean resourceExists(HttpServletRequest servletRequest) {
        return this.nodeService.exists(this.session(), this.getRepoPath(servletRequest));
    }

    private IdentifierConverter<Resource, FedoraResource> translator(HttpServletRequest servletRequest) {
        HttpSession httpSession = new HttpSession(this.session());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)this.getBaseURL(servletRequest)).path(FedoraLdp.class);
        return new HttpResourceConverter(httpSession, uriBuilder);
    }

    private String getRepoPath(HttpServletRequest servletRequest) {
        String httpURI = servletRequest.getRequestURL().toString();
        return this.getRepoPath(servletRequest, httpURI);
    }

    private String getRepoPath(HttpServletRequest servletRequest, String httpURI) {
        Resource resource = ModelFactory.createDefaultModel().createResource(httpURI);
        String repoPath = this.translator(servletRequest).asString((Object)resource);
        log.debug("Converted request URI {} to repo path {}", (Object)httpURI, (Object)repoPath);
        return repoPath;
    }

    private boolean isAuthorized(Subject currentUser, HttpServletRequest httpRequest) throws IOException {
        String requestURL = httpRequest.getRequestURL().toString();
        boolean isAcl = requestURL.endsWith("fcr:acl");
        URI requestURI = URI.create(requestURL);
        log.debug("Request URI is {}", (Object)requestURI);
        WebACPermission toRead = new WebACPermission(URIConstants.WEBAC_MODE_READ, requestURI);
        WebACPermission toWrite = new WebACPermission(URIConstants.WEBAC_MODE_WRITE, requestURI);
        WebACPermission toAppend = new WebACPermission(URIConstants.WEBAC_MODE_APPEND, requestURI);
        WebACPermission toControl = new WebACPermission(URIConstants.WEBAC_MODE_CONTROL, requestURI);
        switch (httpRequest.getMethod()) {
            case "OPTIONS": 
            case "HEAD": 
            case "GET": {
                if (isAcl) {
                    if (currentUser.isPermitted((Permission)toControl)) {
                        log.debug("GET allowed by {} permission", (Object)toControl);
                        return true;
                    }
                    log.debug("GET prohibited without {} permission", (Object)toControl);
                    return false;
                }
                return currentUser.isPermitted((Permission)toRead);
            }
            case "PUT": {
                if (isAcl) {
                    if (currentUser.isPermitted((Permission)toControl)) {
                        log.debug("PUT allowed by {} permission", (Object)toControl);
                        return true;
                    }
                    log.debug("PUT prohibited without {} permission", (Object)toControl);
                    return false;
                }
                if (currentUser.isPermitted((Permission)toWrite)) {
                    if (!this.isAuthorizedForMembershipResource(httpRequest, currentUser)) {
                        log.debug("PUT denied, not authorized to write to membershipRelation");
                        return false;
                    }
                    log.debug("PUT allowed by {} permission", (Object)toWrite);
                    return true;
                }
                if (this.resourceExists(httpRequest)) {
                    log.debug("PUT prohibited to existing resource without {} permission", (Object)toWrite);
                    return false;
                }
                log.debug("Resource doesn't exist; checking parent resources for acl:Append permission");
                if (currentUser.isPermitted((Permission)toAppend)) {
                    if (!this.isAuthorizedForMembershipResource(httpRequest, currentUser)) {
                        log.debug("PUT denied, not authorized to write to membershipRelation");
                        return false;
                    }
                    log.debug("PUT allowed for new resource by inherited {} permission", (Object)toAppend);
                    return true;
                }
                log.debug("PUT prohibited for new resource without inherited {} permission", (Object)toAppend);
                return false;
            }
            case "POST": {
                if (currentUser.isPermitted((Permission)toWrite)) {
                    if (!this.isAuthorizedForMembershipResource(httpRequest, currentUser)) {
                        log.debug("POST denied, not authorized to write to membershipRelation");
                        return false;
                    }
                    log.debug("POST allowed by {} permission", (Object)toWrite);
                    return true;
                }
                if (this.resourceExists(httpRequest)) {
                    if (this.resource(httpRequest).hasType("fedora:Binary")) {
                        log.debug("POST prohibited to binary resource without {} permission", (Object)toWrite);
                        return false;
                    }
                    if (currentUser.isPermitted((Permission)toAppend)) {
                        if (!this.isAuthorizedForMembershipResource(httpRequest, currentUser)) {
                            log.debug("POST denied, not authorized to write to membershipRelation");
                            return false;
                        }
                        log.debug("POST allowed to container by {} permission", (Object)toAppend);
                        return true;
                    }
                    log.debug("POST prohibited to container without {} permission", (Object)toAppend);
                    return false;
                }
                log.debug("POST prohibited to non-existent resource without {} permission", (Object)toWrite);
                return false;
            }
            case "DELETE": {
                if (isAcl) {
                    if (currentUser.isPermitted((Permission)toControl)) {
                        log.debug("DELETE allowed by {} permission", (Object)toControl);
                        return true;
                    }
                    log.debug("DELETE prohibited without {} permission", (Object)toControl);
                    return false;
                }
                if (!this.isAuthorizedForMembershipResource(httpRequest, currentUser)) {
                    log.debug("DELETE denied, not authorized to write to membershipRelation");
                    return false;
                }
                return currentUser.isPermitted((Permission)toWrite);
            }
            case "PATCH": {
                if (isAcl) {
                    if (currentUser.isPermitted((Permission)toControl)) {
                        log.debug("PATCH allowed by {} permission", (Object)toControl);
                        return true;
                    }
                    log.debug("PATCH prohibited without {} permission", (Object)toControl);
                    return false;
                }
                if (currentUser.isPermitted((Permission)toWrite)) {
                    if (!this.isAuthorizedForMembershipResource(httpRequest, currentUser)) {
                        log.debug("PATCH denied, not authorized to write to membershipRelation");
                        return false;
                    }
                    return true;
                }
                if (currentUser.isPermitted((Permission)toAppend)) {
                    if (!this.isAuthorizedForMembershipResource(httpRequest, currentUser)) {
                        log.debug("PATCH denied, not authorized to write to membershipRelation");
                        return false;
                    }
                    return this.isPatchContentPermitted(httpRequest);
                }
                return false;
            }
        }
        return false;
    }

    private boolean isPatchContentPermitted(HttpServletRequest httpRequest) throws IOException {
        if (!this.isSparqlUpdate(httpRequest)) {
            log.debug("Cannot verify authorization on NON-SPARQL Patch request.");
            return false;
        }
        if (httpRequest.getInputStream() != null) {
            boolean noDeletes = false;
            try {
                noDeletes = !this.hasDeleteClause(IOUtils.toString((InputStream)httpRequest.getInputStream(), (Charset)StandardCharsets.UTF_8));
            }
            catch (QueryParseException ex) {
                log.error("Cannot verify authorization! Exception while inspecting SPARQL query!", (Throwable)ex);
            }
            return noDeletes;
        }
        log.debug("Authorizing SPARQL request with no content.");
        return true;
    }

    private boolean hasDeleteClause(String sparqlString) {
        UpdateRequest sparqlUpdate = UpdateFactory.create((String)sparqlString);
        return sparqlUpdate.getOperations().stream().filter(update -> update instanceof UpdateDataDelete).map(update -> (UpdateDataDelete)update).anyMatch(update -> update.getQuads().size() > 0) || sparqlUpdate.getOperations().stream().filter(update -> update instanceof UpdateModify).peek(update -> log.debug("Inspecting update statement for DELETE clause: {}", (Object)update.toString())).map(update -> (UpdateModify)update).filter(UpdateModify::hasDeleteClause).anyMatch(update -> update.getDeleteQuads().size() > 0);
    }

    private boolean isSparqlUpdate(HttpServletRequest request) {
        try {
            return request.getMethod().equals("PATCH") && sparqlUpdate.isCompatible(MediaType.valueOf((String)request.getContentType()));
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private boolean isRdfRequest(HttpServletRequest request) {
        return rdfContentTypes.contains(request.getContentType());
    }

    private boolean isPayloadIndirectOrDirect(HttpServletRequest request) {
        return Collections.list(request.getHeaders("Link")).stream().map(Link::valueOf).map(Link::getUri).anyMatch(l -> directOrIndirect.contains(l));
    }

    private boolean isResourceIndirectOrDirect(FedoraResource resource) {
        return resource.getTypes().stream().anyMatch(l -> directOrIndirect.contains(l));
    }

    private boolean isAuthorizedForMembershipResource(HttpServletRequest request, Subject currentUser) throws IOException {
        URI membershipResource;
        if (this.resourceExists(request) && request.getMethod().equalsIgnoreCase("POST")) {
            if (this.isResourceIndirectOrDirect(this.resource(request))) {
                membershipResource = this.getHasMemberFromResource(request);
                this.addURIToAuthorize(request, membershipResource);
                if (!currentUser.isPermitted((Permission)new WebACPermission(URIConstants.WEBAC_MODE_WRITE, membershipResource))) {
                    return false;
                }
            }
        } else if (request.getMethod().equalsIgnoreCase("PUT")) {
            if (this.containerExists(request) && this.isResourceIndirectOrDirect(this.getContainer(request))) {
                membershipResource = this.getHasMemberFromResource(request, this.getContainer(request));
                this.addURIToAuthorize(request, membershipResource);
                if (!currentUser.isPermitted((Permission)new WebACPermission(URIConstants.WEBAC_MODE_WRITE, membershipResource))) {
                    return false;
                }
            }
        } else if (this.isSparqlUpdate(request) && this.isResourceIndirectOrDirect(this.resource(request))) {
            membershipResource = this.getHasMemberFromPatch(request);
            if (membershipResource != null) {
                log.debug("Found membership resource: {}", (Object)membershipResource);
                this.addURIToAuthorize(request, membershipResource);
                if (!currentUser.isPermitted((Permission)new WebACPermission(URIConstants.WEBAC_MODE_WRITE, membershipResource))) {
                    return false;
                }
            }
        } else if (request.getMethod().equalsIgnoreCase("DELETE")) {
            if (this.isResourceIndirectOrDirect(this.resource(request))) {
                membershipResource = this.getHasMemberFromResource(request);
                this.addURIToAuthorize(request, membershipResource);
                if (!currentUser.isPermitted((Permission)new WebACPermission(URIConstants.WEBAC_MODE_WRITE, membershipResource))) {
                    return false;
                }
            } else if (this.isResourceIndirectOrDirect(this.getContainer(request))) {
                FedoraResource container = this.getContainer(request);
                URI membershipResource2 = this.getHasMemberFromResource(request, container);
                this.addURIToAuthorize(request, membershipResource2);
                if (!currentUser.isPermitted((Permission)new WebACPermission(URIConstants.WEBAC_MODE_WRITE, membershipResource2))) {
                    return false;
                }
            }
        }
        if (this.isPayloadIndirectOrDirect(request) && (membershipResource = this.getHasMemberFromRequest(request)) != null) {
            log.debug("Found membership resource: {}", (Object)membershipResource);
            this.addURIToAuthorize(request, membershipResource);
            if (!currentUser.isPermitted((Permission)new WebACPermission(URIConstants.WEBAC_MODE_WRITE, membershipResource))) {
                return false;
            }
        }
        return true;
    }

    private URI getHasMemberFromRequest(HttpServletRequest request) throws IOException {
        String baseUri = request.getRequestURL().toString();
        String contentType = request.getContentType();
        Lang format = RDFLanguages.contentTypeToLang((String)contentType);
        try {
            Model inputModel = ModelFactory.createDefaultModel();
            RDFReader reader = inputModel.getReader(format.getName().toUpperCase());
            reader.read(inputModel, (InputStream)request.getInputStream(), baseUri);
            Statement st = inputModel.getProperty(null, RdfLexicon.MEMBERSHIP_RESOURCE);
            return st != null ? URI.create(st.getObject().toString()) : null;
        }
        catch (RiotException e) {
            throw new BadRequestException("RDF was not parsable: " + e.getMessage(), (Throwable)e);
        }
        catch (RuntimeIOException e) {
            if (e.getCause() instanceof JsonParseException) {
                throw new MalformedRdfException(e.getCause());
            }
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    private URI getHasMemberFromPatch(HttpServletRequest request) throws IOException {
        String sparqlString = IOUtils.toString((InputStream)request.getInputStream(), (Charset)StandardCharsets.UTF_8);
        String baseURI = request.getRequestURL().toString().replace(request.getContextPath(), "").replaceAll(request.getPathInfo(), "").replaceAll("rest$", "");
        UpdateRequest sparqlUpdate = UpdateFactory.create((String)sparqlString);
        Stream insertDeleteData = sparqlUpdate.getOperations().stream().filter(update -> update instanceof UpdateData).map(update -> (UpdateData)update).flatMap(update -> update.getQuads().stream());
        List updateModifyStream = sparqlUpdate.getOperations().stream().filter(update -> update instanceof UpdateModify).peek(update -> log.debug("Inspecting update statement for DELETE clause: {}", (Object)update.toString())).map(update -> (UpdateModify)update).collect(Collectors.toList());
        Stream insertQuadData = updateModifyStream.stream().flatMap(update -> update.getInsertQuads().stream());
        Stream deleteQuadData = updateModifyStream.stream().flatMap(update -> update.getDeleteQuads().stream());
        return Stream.concat(Stream.concat(insertDeleteData, insertQuadData), deleteQuadData).filter(update -> update.getPredicate().equals((Object)RdfLexicon.MEMBERSHIP_RESOURCE.asNode()) && update.getObject().isURI()).map(update -> update.getObject().getURI()).map(update -> update.replace("file:///", baseURI)).findFirst().map(URI::create).orElse(null);
    }

    private URI getHasMemberFromResource(HttpServletRequest request) {
        FedoraResource resource = this.resource(request);
        return this.getHasMemberFromResource(request, resource);
    }

    private URI getHasMemberFromResource(HttpServletRequest request, FedoraResource resource) {
        return resource.getTriples(this.translator(request), EnumSet.of(RequiredRdfContext.PROPERTIES)).filter(triple -> triple.getPredicate().equals((Object)RdfLexicon.MEMBERSHIP_RESOURCE.asNode()) && triple.getObject().isURI()).map(Triple::getObject).map(Node::getURI).findFirst().map(URI::create).orElse(null);
    }

    static {
        directOrIndirect = new HashSet<URI>();
        rdfContentTypes = new HashSet<String>();
        directOrIndirect.add(URI.create(RdfLexicon.INDIRECT_CONTAINER.toString()));
        directOrIndirect.add(URI.create(RdfLexicon.DIRECT_CONTAINER.toString()));
        rdfContentTypes.add("text/turtle");
        rdfContentTypes.add("application/ld+json");
        rdfContentTypes.add("text/rdf+n3");
        rdfContentTypes.add("application/rdf+xml");
        rdfContentTypes.add("application/n-triples");
    }
}

