/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.auth.webac;

import java.net.URI;
import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.inject.Inject;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.http.auth.BasicUserPrincipal;
import org.apache.jena.rdf.model.Resource;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.fcrepo.auth.common.ContainerRolesPrincipalProvider;
import org.fcrepo.auth.common.DelegateHeaderPrincipalProvider;
import org.fcrepo.auth.common.HttpHeaderPrincipalProvider;
import org.fcrepo.auth.webac.WebACPermission;
import org.fcrepo.auth.webac.WebACRolesProvider;
import org.fcrepo.http.api.FedoraLdp;
import org.fcrepo.http.commons.api.rdf.HttpResourceConverter;
import org.fcrepo.http.commons.session.HttpSession;
import org.fcrepo.http.commons.session.SessionFactory;
import org.fcrepo.kernel.api.exception.RepositoryConfigurationException;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.api.identifiers.IdentifierConverter;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.fcrepo.kernel.modeshape.FedoraResourceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebACAuthorizingRealm
extends AuthorizingRealm {
    private static final Logger log = LoggerFactory.getLogger(WebACAuthorizingRealm.class);
    private static final ContainerRolesPrincipalProvider.ContainerRolesPrincipal adminPrincipal = new ContainerRolesPrincipalProvider.ContainerRolesPrincipal("fedoraAdmin");
    private static final ContainerRolesPrincipalProvider.ContainerRolesPrincipal userPrincipal = new ContainerRolesPrincipalProvider.ContainerRolesPrincipal("fedoraUser");
    public static final String URIS_TO_AUTHORIZE = "URIS_TO_AUTHORIZE";
    @Inject
    private SessionFactory sessionFactory;
    @Inject
    private HttpServletRequest request;
    @Inject
    private WebACRolesProvider rolesProvider;
    private HttpSession session;
    private IdentifierConverter<Resource, FedoraResource> idTranslator;
    @Context
    private UriInfo uriInfo;

    private HttpSession session() {
        if (this.session == null) {
            this.session = this.sessionFactory.getSession(this.request);
        }
        return this.session;
    }

    private IdentifierConverter<Resource, FedoraResource> translator() {
        if (this.idTranslator == null) {
            this.idTranslator = new HttpResourceConverter(this.session(), UriBuilder.fromResource(FedoraLdp.class));
        }
        return this.idTranslator;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        SimpleAuthorizationInfo authzInfo = new SimpleAuthorizationInfo();
        boolean isAdmin = false;
        Collection delegatePrincipals = principals.byType(DelegateHeaderPrincipalProvider.DelegatedHeaderPrincipal.class);
        if (principals.byType(ContainerRolesPrincipalProvider.ContainerRolesPrincipal.class).contains(adminPrincipal)) {
            if (delegatePrincipals.size() > 1) {
                throw new RepositoryConfigurationException("Too many delegates! " + delegatePrincipals);
            }
            if (delegatePrincipals.size() < 1) {
                authzInfo.addRole("fedoraAdmin");
                return authzInfo;
            }
            isAdmin = true;
            authzInfo.addRole("fedoraUser");
        } else if (principals.byType(ContainerRolesPrincipalProvider.ContainerRolesPrincipal.class).contains(userPrincipal)) {
            authzInfo.addRole("fedoraUser");
        }
        HashSet targetURIs = (HashSet)this.request.getAttribute(URIS_TO_AUTHORIZE);
        if (targetURIs == null) {
            targetURIs = new HashSet();
        }
        HashMap<URI, Map<String, Collection<String>>> rolesForURI = new HashMap<URI, Map<String, Collection<String>>>();
        String contextPath = this.request.getContextPath() + this.request.getServletPath();
        for (URI uri : targetURIs) {
            String path = uri.getPath();
            if (path.startsWith(contextPath)) {
                path = path.replaceFirst(contextPath, "");
            }
            log.debug("Getting roles for path {}", (Object)path);
            rolesForURI.put(uri, this.getRolesForPath(path));
        }
        for (Object o : principals.asList()) {
            log.debug("User has principal with name: {}", (Object)((Principal)o).getName());
        }
        Principal userPrincipal = (Principal)principals.oneByType(BasicUserPrincipal.class);
        Collection headerPrincipals = principals.byType(HttpHeaderPrincipalProvider.HttpHeaderPrincipal.class);
        if (isAdmin && delegatePrincipals.size() == 1) {
            DelegateHeaderPrincipalProvider.DelegatedHeaderPrincipal delegatedPrincipal = (DelegateHeaderPrincipalProvider.DelegatedHeaderPrincipal)delegatePrincipals.iterator().next();
            log.debug("Admin user is delegating to {}", (Object)delegatedPrincipal);
            this.addPermissions(authzInfo, rolesForURI, delegatedPrincipal.getName());
            this.addPermissions(authzInfo, rolesForURI, "http://www.w3.org/ns/auth/acl#AuthenticatedAgent");
        } else if (userPrincipal != null) {
            log.debug("Basic user principal username: {}", (Object)userPrincipal.getName());
            this.addPermissions(authzInfo, rolesForURI, userPrincipal.getName());
            this.addPermissions(authzInfo, rolesForURI, "http://www.w3.org/ns/auth/acl#AuthenticatedAgent");
        } else {
            log.debug("No basic user principal found");
        }
        if (headerPrincipals.isEmpty()) {
            log.debug("No header principals found!");
        }
        headerPrincipals.forEach(headerPrincipal -> this.addPermissions(authzInfo, rolesForURI, headerPrincipal.getName()));
        this.addPermissions(authzInfo, rolesForURI, "http://xmlns.com/foaf/0.1/Agent");
        return authzInfo;
    }

    private Map<String, Collection<String>> getRolesForPath(String path) {
        Map<String, Collection<String>> roles = null;
        FedoraResource fedoraResource = this.getResourceOrParentFromPath(path);
        if (fedoraResource != null) {
            Node node = ((FedoraResourceImpl)fedoraResource).getNode();
            roles = this.rolesProvider.getRoles(node);
        }
        return roles;
    }

    private void addPermissions(SimpleAuthorizationInfo authzInfo, Map<URI, Map<String, Collection<String>>> rolesForURI, String agentName) {
        if (rolesForURI != null) {
            for (URI uri : rolesForURI.keySet()) {
                Collection<String> modesForUser;
                log.debug("Adding permissions gathered for URI {}", (Object)uri);
                Map<String, Collection<String>> roles = rolesForURI.get(uri);
                if (roles == null || (modesForUser = roles.get(agentName)) == null) continue;
                for (String mode : modesForUser) {
                    WebACPermission perm = new WebACPermission(URI.create(mode), uri);
                    authzInfo.addObjectPermission((Permission)perm);
                    log.debug("Added permission {}", (Object)perm);
                }
            }
        }
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        return null;
    }

    public boolean supports(AuthenticationToken token) {
        return false;
    }

    private FedoraResource getResourceOrParentFromPath(String path) {
        FedoraResource resource;
        block2: {
            resource = null;
            log.debug("Attempting to get FedoraResource for {}", (Object)path);
            try {
                resource = (FedoraResource)this.translator().convert(this.translator().toDomain(path));
                log.debug("Got FedoraResource for {}", (Object)path);
            }
            catch (RepositoryRuntimeException e) {
                if (!(e.getCause() instanceof PathNotFoundException)) break block2;
                log.debug("Path {} does not exist", (Object)path);
                if (path.length() <= 1) break block2;
                int lastSlash = path.lastIndexOf("/");
                int end = lastSlash > 0 ? lastSlash : lastSlash + 1;
                resource = this.getResourceOrParentFromPath(path.substring(0, end));
            }
        }
        return resource;
    }
}

