/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.auth.webac;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.io.IOUtils;

public class CachedHttpRequest
extends HttpServletRequestWrapper {
    private byte[] cachedContent;
    private BufferedReader reader;

    public CachedHttpRequest(ServletRequest request) {
        super((HttpServletRequest)request);
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.getRequest().getInputStream() != null) {
            if (this.cachedContent == null) {
                this.cachedContent = IOUtils.toByteArray((InputStream)this.getRequest().getInputStream());
            }
            return new CustomServletInputStream(this.cachedContent);
        }
        return null;
    }

    public BufferedReader getReader() throws IOException {
        if (this.reader == null) {
            this.reader = new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), this.getCharacterEncoding()));
        }
        return this.reader;
    }

    private static class CustomServletInputStream
    extends ServletInputStream {
        private final ByteArrayInputStream buffer;

        public CustomServletInputStream(byte[] contents) {
            this.buffer = new ByteArrayInputStream(contents);
        }

        public int read() {
            return this.buffer.read();
        }

        public boolean isFinished() {
            return this.buffer.available() == 0;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener listener) {
            throw new RuntimeException("Not implemented");
        }
    }
}

