/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.auth.webac;

import java.net.URI;
import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.auth.BasicUserPrincipal;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.fcrepo.auth.common.ContainerRolesPrincipalProvider;
import org.fcrepo.auth.common.DelegateHeaderPrincipalProvider;
import org.fcrepo.auth.common.HttpHeaderPrincipalProvider;
import org.fcrepo.auth.webac.WebACFilter;
import org.fcrepo.auth.webac.WebACPermission;
import org.fcrepo.auth.webac.WebACRolesProvider;
import org.fcrepo.config.FedoraPropsConfig;
import org.fcrepo.http.commons.session.TransactionProvider;
import org.fcrepo.kernel.api.ContainmentIndex;
import org.fcrepo.kernel.api.ReadOnlyTransaction;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.TransactionManager;
import org.fcrepo.kernel.api.exception.PathNotFoundException;
import org.fcrepo.kernel.api.exception.RepositoryConfigurationException;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.fcrepo.kernel.api.models.ResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class WebACAuthorizingRealm
extends AuthorizingRealm {
    private static final Logger log = LoggerFactory.getLogger(WebACAuthorizingRealm.class);
    private static final ContainerRolesPrincipalProvider.ContainerRolesPrincipal adminPrincipal = new ContainerRolesPrincipalProvider.ContainerRolesPrincipal("fedoraAdmin");
    private static final ContainerRolesPrincipalProvider.ContainerRolesPrincipal userPrincipal = new ContainerRolesPrincipalProvider.ContainerRolesPrincipal("fedoraUser");
    public static final String URIS_TO_AUTHORIZE = "URIS_TO_AUTHORIZE";
    @Inject
    private FedoraPropsConfig fedoraPropsConfig;
    @Inject
    private HttpServletRequest request;
    @Inject
    private WebACRolesProvider rolesProvider;
    @Inject
    private TransactionManager transactionManager;
    @Inject
    private ResourceFactory resourceFactory;
    @Autowired
    @Qualifier(value="containmentIndex")
    private ContainmentIndex containmentIndex;

    private Transaction transaction() {
        String txId = this.request.getHeader("Atomic-ID");
        if (txId == null) {
            return ReadOnlyTransaction.INSTANCE;
        }
        TransactionProvider txProvider = new TransactionProvider(this.transactionManager, this.request, WebACFilter.getBaseUri(this.request), this.fedoraPropsConfig.getJmsBaseUrl());
        return txProvider.provide();
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        SimpleAuthorizationInfo authzInfo = new SimpleAuthorizationInfo();
        boolean isAdmin = false;
        Collection delegatePrincipals = principals.byType(DelegateHeaderPrincipalProvider.DelegatedHeaderPrincipal.class);
        if (principals.byType(ContainerRolesPrincipalProvider.ContainerRolesPrincipal.class).contains(adminPrincipal)) {
            if (delegatePrincipals.size() > 1) {
                throw new RepositoryConfigurationException("Too many delegates! " + delegatePrincipals);
            }
            if (delegatePrincipals.size() < 1) {
                authzInfo.addRole("fedoraAdmin");
                return authzInfo;
            }
            isAdmin = true;
            authzInfo.addRole("fedoraUser");
        } else if (principals.byType(ContainerRolesPrincipalProvider.ContainerRolesPrincipal.class).contains(userPrincipal)) {
            authzInfo.addRole("fedoraUser");
        }
        HashSet targetURIs = (HashSet)this.request.getAttribute(URIS_TO_AUTHORIZE);
        if (targetURIs == null) {
            targetURIs = new HashSet();
        }
        HashMap<URI, Map<String, Collection<String>>> rolesForURI = new HashMap<URI, Map<String, Collection<String>>>();
        String contextPath = this.request.getContextPath() + this.request.getServletPath();
        for (URI uri : targetURIs) {
            if (WebACFilter.identifierConverter(this.request).inInternalDomain(uri.toString())) {
                FedoraId id = FedoraId.create((String[])new String[]{uri.toString()});
                log.debug("Getting roles for id {}", (Object)id.getFullId());
                rolesForURI.put(uri, this.getRolesForId(id));
                continue;
            }
            String path = uri.getPath();
            if (path.startsWith(contextPath)) {
                path = path.replaceFirst(contextPath, "");
            }
            log.debug("Getting roles for path {}", (Object)path);
            rolesForURI.put(uri, this.getRolesForPath(path));
        }
        for (Object o : principals.asList()) {
            log.debug("User has principal with name: {}", (Object)((Principal)o).getName());
        }
        Principal userPrincipal = (Principal)principals.oneByType(BasicUserPrincipal.class);
        Collection headerPrincipals = principals.byType(HttpHeaderPrincipalProvider.HttpHeaderPrincipal.class);
        if (isAdmin && delegatePrincipals.size() == 1) {
            DelegateHeaderPrincipalProvider.DelegatedHeaderPrincipal delegatedPrincipal = (DelegateHeaderPrincipalProvider.DelegatedHeaderPrincipal)delegatePrincipals.iterator().next();
            log.debug("Admin user is delegating to {}", (Object)delegatedPrincipal);
            this.addPermissions(authzInfo, rolesForURI, delegatedPrincipal.getName());
            this.addPermissions(authzInfo, rolesForURI, "http://www.w3.org/ns/auth/acl#AuthenticatedAgent");
        } else if (userPrincipal != null) {
            log.debug("Basic user principal username: {}", (Object)userPrincipal.getName());
            this.addPermissions(authzInfo, rolesForURI, userPrincipal.getName());
            this.addPermissions(authzInfo, rolesForURI, "http://www.w3.org/ns/auth/acl#AuthenticatedAgent");
        } else {
            log.debug("No basic user principal found");
        }
        if (headerPrincipals.isEmpty()) {
            log.debug("No header principals found!");
        }
        headerPrincipals.forEach(headerPrincipal -> this.addPermissions(authzInfo, rolesForURI, headerPrincipal.getName()));
        this.addPermissions(authzInfo, rolesForURI, "http://xmlns.com/foaf/0.1/Agent");
        return authzInfo;
    }

    private Map<String, Collection<String>> getRolesForPath(String path) {
        FedoraId id = WebACFilter.identifierConverter(this.request).pathToInternalId(path);
        return this.getRolesForId(id);
    }

    private Map<String, Collection<String>> getRolesForId(FedoraId id) {
        Map<String, Collection<String>> roles = null;
        String txId = "info:fedora/fcr:tx";
        FedoraResource fedoraResource = this.getResourceOrParentFromPath(id);
        if (id.getResourceId().startsWith("info:fedora/fcr:tx") && fedoraResource != null) {
            roles = this.rolesProvider.getRoles(id, fedoraResource, this.transaction());
        } else if (fedoraResource != null) {
            roles = this.rolesProvider.getRoles(fedoraResource, this.transaction());
        }
        return roles;
    }

    private void addPermissions(SimpleAuthorizationInfo authzInfo, Map<URI, Map<String, Collection<String>>> rolesForURI, String agentName) {
        if (rolesForURI != null) {
            for (URI uri : rolesForURI.keySet()) {
                Collection<String> modesForUser;
                log.debug("Adding permissions gathered for URI {}", (Object)uri);
                Map<String, Collection<String>> roles = rolesForURI.get(uri);
                if (roles == null || (modesForUser = roles.get(agentName)) == null) continue;
                for (String mode : modesForUser) {
                    WebACPermission perm = new WebACPermission(URI.create(mode), uri);
                    authzInfo.addObjectPermission((Permission)perm);
                }
            }
        }
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        return null;
    }

    public boolean supports(AuthenticationToken token) {
        return false;
    }

    private FedoraResource getResourceOrParentFromPath(FedoraId fedoraId) {
        try {
            log.debug("Testing FedoraResource for {}", (Object)fedoraId.getFullIdPath());
            return this.resourceFactory.getResource(this.transaction(), fedoraId);
        }
        catch (PathNotFoundException exc) {
            log.debug("Resource {} not found getting container", (Object)fedoraId.getFullIdPath());
            FedoraId containerId = this.containmentIndex.getContainerIdByPath(this.transaction(), fedoraId, false);
            log.debug("Attempting to get FedoraResource for {}", (Object)fedoraId.getFullIdPath());
            try {
                log.debug("Got FedoraResource for {}", (Object)containerId.getFullIdPath());
                return this.resourceFactory.getResource(this.transaction(), containerId);
            }
            catch (PathNotFoundException exc2) {
                log.debug("Path {} does not exist, but we should never end up here.", (Object)containerId.getFullIdPath());
                return null;
            }
        }
    }
}

