/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.auth.webac;

import com.fasterxml.jackson.core.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFReaderI;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RiotException;
import org.apache.jena.sparql.modify.request.UpdateData;
import org.apache.jena.sparql.modify.request.UpdateDataDelete;
import org.apache.jena.sparql.modify.request.UpdateModify;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.fcrepo.auth.webac.CachedHttpRequest;
import org.fcrepo.auth.webac.URIConstants;
import org.fcrepo.auth.webac.WebACAuthorizingRealm;
import org.fcrepo.auth.webac.WebACPermission;
import org.fcrepo.config.FedoraPropsConfig;
import org.fcrepo.http.commons.api.rdf.HttpIdentifierConverter;
import org.fcrepo.http.commons.domain.MultiPrefer;
import org.fcrepo.http.commons.domain.SinglePrefer;
import org.fcrepo.http.commons.domain.ldp.LdpPreferTag;
import org.fcrepo.http.commons.session.TransactionProvider;
import org.fcrepo.kernel.api.RdfLexicon;
import org.fcrepo.kernel.api.ReadOnlyTransaction;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.TransactionManager;
import org.fcrepo.kernel.api.exception.ConstraintViolationException;
import org.fcrepo.kernel.api.exception.InvalidMementoPathException;
import org.fcrepo.kernel.api.exception.InvalidResourceIdentifierException;
import org.fcrepo.kernel.api.exception.MalformedRdfException;
import org.fcrepo.kernel.api.exception.PathNotFoundException;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.api.exception.TransactionRuntimeException;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.fcrepo.kernel.api.models.ResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.RequestContextFilter;

public class WebACFilter
extends RequestContextFilter {
    private static final Logger log = LoggerFactory.getLogger(WebACFilter.class);
    private static final MediaType sparqlUpdate = MediaType.valueOf((String)"application/sparql-update");
    private static final Principal FOAF_AGENT_PRINCIPAL = new Principal(){

        @Override
        public String getName() {
            return "http://xmlns.com/foaf/0.1/Agent";
        }

        @Override
        public String toString() {
            return this.getName();
        }
    };
    private static final PrincipalCollection FOAF_AGENT_PRINCIPAL_COLLECTION = new SimplePrincipalCollection((Object)FOAF_AGENT_PRINCIPAL, WebACAuthorizingRealm.class.getCanonicalName());
    private static Subject FOAF_AGENT_SUBJECT;
    @Inject
    private FedoraPropsConfig fedoraPropsConfig;
    @Inject
    private ResourceFactory resourceFactory;
    @Inject
    private TransactionManager transactionManager;
    private static Set<URI> directOrIndirect;
    private static Set<String> rdfContentTypes;

    public static HttpIdentifierConverter identifierConverter(HttpServletRequest request) {
        UriBuilder uriBuild = UriBuilder.fromUri((URI)WebACFilter.getBaseUri(request)).path("/{path: .*}");
        return new HttpIdentifierConverter(uriBuild);
    }

    public static URI getBaseUri(HttpServletRequest request) {
        String host = request.getScheme() + "://" + request.getServerName() + (String)(request.getServerPort() != 80 ? ":" + request.getServerPort() : "") + "/";
        String requestUrl = request.getRequestURL().toString();
        String contextPath = request.getContextPath() + request.getServletPath();
        String baseUri = contextPath.length() == 0 ? host : requestUrl.split(contextPath)[0] + contextPath + "/";
        return URI.create(baseUri);
    }

    private void addURIToAuthorize(HttpServletRequest httpRequest, URI uri) {
        HashSet<URI> targetURIs = (HashSet<URI>)httpRequest.getAttribute("URIS_TO_AUTHORIZE");
        if (targetURIs == null) {
            targetURIs = new HashSet<URI>();
            httpRequest.setAttribute("URIS_TO_AUTHORIZE", targetURIs);
        }
        targetURIs.add(uri);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        void var5_8;
        block13: {
            try {
                this.transaction(request);
            }
            catch (TransactionRuntimeException e) {
                this.printException(response, 409, e, Set.of());
                return;
            }
            Subject currentUser = SecurityUtils.getSubject();
            HttpServletRequest httpServletRequest = request;
            if (this.isSparqlUpdate(httpServletRequest) || this.isRdfRequest(httpServletRequest)) {
                CachedHttpRequest cachedHttpRequest = new CachedHttpRequest((ServletRequest)httpServletRequest);
            }
            String requestUrl = var5_8.getRequestURL().toString();
            try {
                FedoraId.create((String[])new String[]{WebACFilter.identifierConverter((HttpServletRequest)var5_8).toInternalId(requestUrl)});
                this.addURIToAuthorize((HttpServletRequest)var5_8, URI.create(requestUrl));
                if (currentUser.isAuthenticated()) {
                    log.debug("User is authenticated");
                    if (currentUser.hasRole("fedoraAdmin")) {
                        log.debug("User has fedoraAdmin role");
                        break block13;
                    } else {
                        if (!currentUser.hasRole("fedoraUser")) {
                            log.debug("User has no recognized servlet container role");
                            response.sendError(403);
                            return;
                        }
                        log.debug("User has fedoraUser role");
                        if (!this.isAuthorized(currentUser, (HttpServletRequest)var5_8)) {
                            response.sendError(403);
                            return;
                        }
                    }
                    break block13;
                }
                log.debug("User is NOT authenticated");
                if (!this.isAuthorized(this.getFoafAgentSubject(), (HttpServletRequest)var5_8)) {
                    response.sendError(403);
                    return;
                }
            }
            catch (InvalidResourceIdentifierException e) {
                this.printException(response, 400, e, Set.of());
                return;
            }
            catch (InvalidMementoPathException e) {
                Link link = this.buildConstraintLink(((Object)((Object)e)).getClass(), request);
                this.printException(response, 400, e, Set.of(link));
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        chain.doFilter((ServletRequest)var5_8, (ServletResponse)response);
    }

    private void printException(HttpServletResponse response, int responseCode, Throwable e, Set<Link> constrainedBy) throws IOException {
        String message = e.getMessage();
        response.resetBuffer();
        response.setStatus(responseCode);
        response.setContentType("text/plain;charset=utf-8");
        response.setContentLength(message.length());
        response.setCharacterEncoding("UTF-8");
        constrainedBy.forEach(link -> response.setHeader("Link", link.toString()));
        PrintWriter write = response.getWriter();
        write.write(message);
        write.flush();
    }

    private Link buildConstraintLink(Class<? extends ConstraintViolationException> clazz, HttpServletRequest request) {
        String constraintDir = "/static/constraints/";
        String path = request.getContextPath();
        if (path.equals("/")) {
            path = "";
        }
        URI uri = URI.create(request.getRequestURL().toString());
        String constraintURI = String.format("%s://%s%s%s%s.rdf", uri.getScheme(), uri.getAuthority(), path, "/static/constraints/", clazz.getName().substring(clazz.getName().lastIndexOf(46) + 1));
        return Link.fromUri((String)constraintURI).rel(RdfLexicon.CONSTRAINED_BY.getURI()).build(new Object[0]);
    }

    private Subject getFoafAgentSubject() {
        if (FOAF_AGENT_SUBJECT == null) {
            FOAF_AGENT_SUBJECT = new Subject.Builder().principals(FOAF_AGENT_PRINCIPAL_COLLECTION).buildSubject();
        }
        return FOAF_AGENT_SUBJECT;
    }

    private Transaction transaction(HttpServletRequest request) {
        String txId = request.getHeader("Atomic-ID");
        if (txId == null) {
            return ReadOnlyTransaction.INSTANCE;
        }
        TransactionProvider txProvider = new TransactionProvider(this.transactionManager, request, WebACFilter.getBaseUri(request), this.fedoraPropsConfig.getJmsBaseUrl());
        return txProvider.provide();
    }

    private String getContainerUrl(HttpServletRequest servletRequest) {
        String pathInfo = servletRequest.getPathInfo();
        String baseUrl = servletRequest.getRequestURL().toString().replace(pathInfo, "");
        String[] paths = pathInfo.split("/");
        CharSequence[] parentPaths = Arrays.copyOfRange(paths, 0, paths.length - 1);
        return baseUrl + String.join((CharSequence)"/", parentPaths);
    }

    private FedoraResource getContainer(HttpServletRequest servletRequest) {
        FedoraResource resource = this.resource(servletRequest);
        if (resource != null) {
            return this.resource(servletRequest).getContainer();
        }
        String parentURI = this.getContainerUrl(servletRequest);
        return this.resource(servletRequest, this.getIdFromRequest(servletRequest, parentURI));
    }

    private FedoraResource resource(HttpServletRequest servletRequest) {
        return this.resource(servletRequest, this.getIdFromRequest(servletRequest));
    }

    private FedoraResource resource(HttpServletRequest servletRequest, FedoraId resourceId) {
        try {
            return this.resourceFactory.getResource(this.transaction(servletRequest), resourceId);
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    private FedoraId getIdFromRequest(HttpServletRequest servletRequest) {
        String httpURI = servletRequest.getRequestURL().toString();
        return this.getIdFromRequest(servletRequest, httpURI);
    }

    private FedoraId getIdFromRequest(HttpServletRequest request, String httpURI) {
        return FedoraId.create((String[])new String[]{WebACFilter.identifierConverter(request).toInternalId(httpURI)});
    }

    private boolean isAuthorized(Subject currentUser, HttpServletRequest httpRequest) throws IOException {
        String requestURL = httpRequest.getRequestURL().toString();
        Pattern txOrUuid = Pattern.compile("fcr:tx(/?|/[0-9a-f\\-]+/?)$");
        boolean isTxEndpoint = txOrUuid.matcher(requestURL).find();
        boolean isAcl = requestURL.endsWith("fcr:acl");
        URI requestURI = URI.create(requestURL);
        log.debug("Request URI is {}", (Object)requestURI);
        FedoraResource resource = this.resource(httpRequest);
        FedoraResource container = this.getContainer(httpRequest);
        WebACPermission toRead = new WebACPermission(URIConstants.WEBAC_MODE_READ, requestURI);
        WebACPermission toWrite = new WebACPermission(URIConstants.WEBAC_MODE_WRITE, requestURI);
        WebACPermission toAppend = new WebACPermission(URIConstants.WEBAC_MODE_APPEND, requestURI);
        WebACPermission toControl = new WebACPermission(URIConstants.WEBAC_MODE_CONTROL, requestURI);
        switch (httpRequest.getMethod()) {
            case "OPTIONS": 
            case "HEAD": 
            case "GET": {
                if (isAcl) {
                    if (currentUser.isPermitted((Permission)toControl)) {
                        log.debug("GET allowed by {} permission", (Object)toControl);
                        return true;
                    }
                    log.debug("GET prohibited without {} permission", (Object)toControl);
                    return false;
                }
                if (currentUser.isPermitted((Permission)toRead)) {
                    if (!this.isAuthorizedForEmbeddedRequest(httpRequest, currentUser, resource)) {
                        log.debug("GET/HEAD/OPTIONS request to {} denied, user {} not authorized for an embedded resource", (Object)requestURL, (Object)currentUser.toString());
                        return false;
                    }
                    return true;
                }
                return false;
            }
            case "PUT": {
                if (isAcl) {
                    if (currentUser.isPermitted((Permission)toControl)) {
                        log.debug("PUT allowed by {} permission", (Object)toControl);
                        return true;
                    }
                    log.debug("PUT prohibited without {} permission", (Object)toControl);
                    return false;
                }
                if (currentUser.isPermitted((Permission)toWrite)) {
                    if (!this.isAuthorizedForMembershipResource(httpRequest, currentUser, resource, container)) {
                        log.debug("PUT denied, not authorized to write to membershipRelation");
                        return false;
                    }
                    log.debug("PUT allowed by {} permission", (Object)toWrite);
                    return true;
                }
                if (resource != null) {
                    log.debug("PUT prohibited to existing resource without {} permission", (Object)toWrite);
                    return false;
                }
                log.debug("Resource doesn't exist; checking parent resources for acl:Append permission");
                if (currentUser.isPermitted((Permission)toAppend)) {
                    if (!this.isAuthorizedForMembershipResource(httpRequest, currentUser, resource, container)) {
                        log.debug("PUT denied, not authorized to write to membershipRelation");
                        return false;
                    }
                    log.debug("PUT allowed for new resource by inherited {} permission", (Object)toAppend);
                    return true;
                }
                log.debug("PUT prohibited for new resource without inherited {} permission", (Object)toAppend);
                return false;
            }
            case "POST": {
                if (currentUser.isPermitted((Permission)toWrite)) {
                    if (!this.isAuthorizedForMembershipResource(httpRequest, currentUser, resource, container)) {
                        log.debug("POST denied, not authorized to write to membershipRelation");
                        return false;
                    }
                    log.debug("POST allowed by {} permission", (Object)toWrite);
                    return true;
                }
                if (resource != null) {
                    if (WebACFilter.isBinaryOrDescription(resource)) {
                        log.debug("POST prohibited to binary resource without {} permission", (Object)toWrite);
                        return false;
                    }
                    if (currentUser.isPermitted((Permission)toAppend)) {
                        if (!this.isAuthorizedForMembershipResource(httpRequest, currentUser, resource, container)) {
                            log.debug("POST denied, not authorized to write to membershipRelation");
                            return false;
                        }
                        log.debug("POST allowed to container by {} permission", (Object)toAppend);
                        return true;
                    }
                    log.debug("POST prohibited to container without {} permission", (Object)toAppend);
                    return false;
                }
                log.debug("POST prohibited to non-existent resource without {} permission", (Object)toWrite);
                return false;
            }
            case "DELETE": {
                if (isAcl) {
                    if (currentUser.isPermitted((Permission)toControl)) {
                        log.debug("DELETE allowed by {} permission", (Object)toControl);
                        return true;
                    }
                    log.debug("DELETE prohibited without {} permission", (Object)toControl);
                    return false;
                }
                if (isTxEndpoint) {
                    if (currentUser.isPermitted((Permission)toWrite)) {
                        log.debug("DELETE allowed by {} permission", (Object)toWrite);
                        return true;
                    }
                    log.debug("DELETE prohibited without {} permission", (Object)toWrite);
                    return false;
                }
                if (!this.isAuthorizedForMembershipResource(httpRequest, currentUser, resource, container)) {
                    log.debug("DELETE denied, not authorized to write to membershipRelation");
                    return false;
                }
                if (currentUser.isPermitted((Permission)toWrite)) {
                    if (!this.isAuthorizedForContainedResources(resource, URIConstants.WEBAC_MODE_WRITE, httpRequest, currentUser, true)) {
                        log.debug("DELETE denied, not authorized to write to a descendant of {}", (Object)resource);
                        return false;
                    }
                    return true;
                }
                return false;
            }
            case "PATCH": {
                if (isAcl) {
                    if (currentUser.isPermitted((Permission)toControl)) {
                        log.debug("PATCH allowed by {} permission", (Object)toControl);
                        return true;
                    }
                    log.debug("PATCH prohibited without {} permission", (Object)toControl);
                    return false;
                }
                if (currentUser.isPermitted((Permission)toWrite)) {
                    if (!this.isAuthorizedForMembershipResource(httpRequest, currentUser, resource, container)) {
                        log.debug("PATCH denied, not authorized to write to membershipRelation");
                        return false;
                    }
                    return true;
                }
                if (currentUser.isPermitted((Permission)toAppend)) {
                    if (!this.isAuthorizedForMembershipResource(httpRequest, currentUser, resource, container)) {
                        log.debug("PATCH denied, not authorized to write to membershipRelation");
                        return false;
                    }
                    return this.isPatchContentPermitted(httpRequest);
                }
                return false;
            }
        }
        return false;
    }

    private boolean isPatchContentPermitted(HttpServletRequest httpRequest) throws IOException {
        if (!this.isSparqlUpdate(httpRequest)) {
            log.debug("Cannot verify authorization on NON-SPARQL Patch request.");
            return false;
        }
        if (httpRequest.getInputStream() != null) {
            boolean noDeletes = false;
            try {
                noDeletes = !this.hasDeleteClause(IOUtils.toString((InputStream)httpRequest.getInputStream(), (Charset)StandardCharsets.UTF_8));
            }
            catch (QueryParseException ex) {
                log.error("Cannot verify authorization! Exception while inspecting SPARQL query!", (Throwable)ex);
            }
            return noDeletes;
        }
        log.debug("Authorizing SPARQL request with no content.");
        return true;
    }

    private boolean hasDeleteClause(String sparqlString) {
        UpdateRequest sparqlUpdate = UpdateFactory.create((String)sparqlString);
        return sparqlUpdate.getOperations().stream().filter(update -> update instanceof UpdateDataDelete).map(update -> (UpdateDataDelete)update).anyMatch(update -> update.getQuads().size() > 0) || sparqlUpdate.getOperations().stream().filter(update -> update instanceof UpdateModify).peek(update -> log.debug("Inspecting update statement for DELETE clause: {}", (Object)update.toString())).map(update -> (UpdateModify)update).filter(UpdateModify::hasDeleteClause).anyMatch(update -> update.getDeleteQuads().size() > 0);
    }

    private boolean isSparqlUpdate(HttpServletRequest request) {
        try {
            return request.getMethod().equals("PATCH") && sparqlUpdate.isCompatible(MediaType.valueOf((String)request.getContentType()));
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private boolean isRdfRequest(HttpServletRequest request) {
        return request.getContentType() != null && rdfContentTypes.contains(request.getContentType());
    }

    private boolean isPayloadIndirectOrDirect(HttpServletRequest request) {
        return Collections.list(request.getHeaders("Link")).stream().map(Link::valueOf).map(Link::getUri).anyMatch(directOrIndirect::contains);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isResourceIndirectOrDirect(FedoraResource resource) {
        if (resource == null) return false;
        if (resource.getInteractionModel() == null) return false;
        if (!Stream.of(resource.getInteractionModel()).map(URI::create).anyMatch(directOrIndirect::contains)) return false;
        return true;
    }

    private boolean isAuthorizedForMembershipResource(HttpServletRequest request, Subject currentUser, FedoraResource resource, FedoraResource container) throws IOException {
        URI membershipResource;
        if (resource != null && request.getMethod().equalsIgnoreCase("POST")) {
            if (this.isResourceIndirectOrDirect(resource)) {
                membershipResource = this.getHasMemberFromResource(request);
                this.addURIToAuthorize(request, membershipResource);
                if (!currentUser.isPermitted((Permission)new WebACPermission(URIConstants.WEBAC_MODE_WRITE, membershipResource))) {
                    return false;
                }
            }
        } else if (request.getMethod().equalsIgnoreCase("PUT")) {
            if (this.isResourceIndirectOrDirect(container)) {
                membershipResource = this.getHasMemberFromResource(request, container);
                this.addURIToAuthorize(request, membershipResource);
                if (!currentUser.isPermitted((Permission)new WebACPermission(URIConstants.WEBAC_MODE_WRITE, membershipResource))) {
                    return false;
                }
            }
        } else if (this.isSparqlUpdate(request) && this.isResourceIndirectOrDirect(resource)) {
            membershipResource = this.getHasMemberFromPatch(request);
            if (membershipResource != null) {
                log.debug("Found membership resource: {}", (Object)membershipResource);
                this.addURIToAuthorize(request, membershipResource);
                if (!currentUser.isPermitted((Permission)new WebACPermission(URIConstants.WEBAC_MODE_WRITE, membershipResource))) {
                    return false;
                }
            }
        } else if (request.getMethod().equalsIgnoreCase("DELETE")) {
            if (this.isResourceIndirectOrDirect(resource)) {
                membershipResource = this.getHasMemberFromResource(request);
                this.addURIToAuthorize(request, membershipResource);
                if (!currentUser.isPermitted((Permission)new WebACPermission(URIConstants.WEBAC_MODE_WRITE, membershipResource))) {
                    return false;
                }
            } else if (this.isResourceIndirectOrDirect(container)) {
                membershipResource = this.getHasMemberFromResource(request, container);
                this.addURIToAuthorize(request, membershipResource);
                if (!currentUser.isPermitted((Permission)new WebACPermission(URIConstants.WEBAC_MODE_WRITE, membershipResource))) {
                    return false;
                }
            }
        }
        if (this.isPayloadIndirectOrDirect(request) && (membershipResource = this.getHasMemberFromRequest(request)) != null) {
            log.debug("Found membership resource: {}", (Object)membershipResource);
            this.addURIToAuthorize(request, membershipResource);
            if (!currentUser.isPermitted((Permission)new WebACPermission(URIConstants.WEBAC_MODE_WRITE, membershipResource))) {
                return false;
            }
        }
        return true;
    }

    private URI getHasMemberFromRequest(HttpServletRequest request) throws IOException {
        String baseUri = request.getRequestURL().toString();
        String contentType = request.getContentType();
        Lang format = RDFLanguages.contentTypeToLang((String)contentType);
        try {
            Model inputModel = ModelFactory.createDefaultModel();
            RDFReaderI reader = inputModel.getReader(format.getName().toUpperCase());
            reader.read(inputModel, (InputStream)request.getInputStream(), baseUri);
            Statement st = inputModel.getProperty(null, RdfLexicon.MEMBERSHIP_RESOURCE);
            return st != null ? URI.create(st.getObject().toString()) : null;
        }
        catch (RiotException e) {
            throw new BadRequestException("RDF was not parsable: " + e.getMessage(), (Throwable)e);
        }
        catch (RuntimeIOException e) {
            if (e.getCause() instanceof JsonParseException) {
                Throwable cause = e.getCause();
                throw new MalformedRdfException(cause.getMessage(), cause);
            }
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    private URI getHasMemberFromPatch(HttpServletRequest request) throws IOException {
        String sparqlString = IOUtils.toString((InputStream)request.getInputStream(), (Charset)StandardCharsets.UTF_8);
        String baseURI = request.getRequestURL().toString().replace(request.getContextPath(), "").replaceAll(request.getPathInfo(), "").replaceAll("rest$", "");
        UpdateRequest sparqlUpdate = UpdateFactory.create((String)sparqlString);
        Stream insertDeleteData = sparqlUpdate.getOperations().stream().filter(update -> update instanceof UpdateData).map(update -> (UpdateData)update).flatMap(update -> update.getQuads().stream());
        List updateModifyStream = sparqlUpdate.getOperations().stream().filter(update -> update instanceof UpdateModify).peek(update -> log.debug("Inspecting update statement for DELETE clause: {}", (Object)update.toString())).map(update -> (UpdateModify)update).collect(Collectors.toList());
        Stream insertQuadData = updateModifyStream.stream().flatMap(update -> update.getInsertQuads().stream());
        Stream deleteQuadData = updateModifyStream.stream().flatMap(update -> update.getDeleteQuads().stream());
        return Stream.concat(Stream.concat(insertDeleteData, insertQuadData), deleteQuadData).filter(update -> update.getPredicate().equals((Object)RdfLexicon.MEMBERSHIP_RESOURCE.asNode()) && update.getObject().isURI()).map(update -> update.getObject().getURI()).map(update -> update.replace("file:///", baseURI)).findFirst().map(URI::create).orElse(null);
    }

    private URI getHasMemberFromResource(HttpServletRequest request) {
        FedoraResource resource = this.resource(request);
        return this.getHasMemberFromResource(request, resource);
    }

    private URI getHasMemberFromResource(HttpServletRequest request, FedoraResource resource) {
        return resource.getTriples().filter(triple -> triple.getPredicate().equals((Object)RdfLexicon.MEMBERSHIP_RESOURCE.asNode()) && triple.getObject().isURI()).map(Triple::getObject).map(Node::getURI).findFirst().map(URI::create).orElse(null);
    }

    private static boolean isBinaryOrDescription(FedoraResource resource) {
        return resource != null && resource.getInteractionModel() != null && (resource.getInteractionModel().equals(RdfLexicon.NON_RDF_SOURCE.toString()) || resource.getInteractionModel().equals("http://fedora.info/definitions/v4/repository#NonRdfSourceDescription"));
    }

    private static boolean isEmbeddedRequest(HttpServletRequest request) {
        Enumeration preferTags = request.getHeaders("Prefer");
        HashSet<SinglePrefer> preferTagSet = new HashSet<SinglePrefer>();
        while (preferTags.hasMoreElements()) {
            preferTagSet.add(new SinglePrefer((String)preferTags.nextElement()));
        }
        MultiPrefer multiPrefer = new MultiPrefer(preferTagSet);
        if (multiPrefer.hasReturn().booleanValue()) {
            LdpPreferTag ldpPreferences = new LdpPreferTag(multiPrefer.getReturn());
            return ldpPreferences.displayEmbed();
        }
        return false;
    }

    private boolean isAuthorizedForEmbeddedRequest(HttpServletRequest request, Subject currentUser, FedoraResource resource) {
        if (WebACFilter.isEmbeddedRequest(request)) {
            return this.isAuthorizedForContainedResources(resource, URIConstants.WEBAC_MODE_READ, request, currentUser, false);
        }
        return true;
    }

    private boolean isAuthorizedForContainedResources(FedoraResource resource, URI permission, HttpServletRequest request, Subject currentUser, boolean deepTraversal) {
        if (!WebACFilter.isBinaryOrDescription(resource)) {
            Transaction transaction = this.transaction(request);
            Stream children = this.resourceFactory.getChildren(transaction, resource.getFedoraId());
            return children.noneMatch(resc -> {
                URI childURI = URI.create(resc.getFedoraId().getFullId());
                log.debug("Found embedded resource: {}", resc);
                this.addURIToAuthorize(request, childURI);
                if (!currentUser.isPermitted((Permission)new WebACPermission(permission, childURI))) {
                    log.debug("Failed to access embedded resource: {}", (Object)childURI);
                    return true;
                }
                if (deepTraversal) {
                    return !this.isAuthorizedForContainedResources((FedoraResource)resc, permission, request, currentUser, deepTraversal);
                }
                return false;
            });
        }
        return true;
    }

    static {
        directOrIndirect = Set.of(RdfLexicon.INDIRECT_CONTAINER, RdfLexicon.DIRECT_CONTAINER).stream().map(Resource::toString).map(URI::create).collect(Collectors.toSet());
        rdfContentTypes = Set.of("text/turtle", "application/ld+json", "text/rdf+n3", "application/rdf+xml", "application/n-triples");
    }
}

