/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.client.impl;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.jena.atlas.lib.NotImplemented;
import org.fcrepo.client.FedoraContent;
import org.fcrepo.client.FedoraDatastream;
import org.fcrepo.client.FedoraException;
import org.fcrepo.client.FedoraObject;
import org.fcrepo.client.FedoraRepository;
import org.fcrepo.client.ForbiddenException;
import org.fcrepo.client.NotFoundException;
import org.fcrepo.client.impl.FedoraResourceImpl;
import org.fcrepo.client.utils.HttpHelper;
import org.fcrepo.kernel.RdfLexicon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FedoraDatastreamImpl
extends FedoraResourceImpl
implements FedoraDatastream {
    private static final Logger LOGGER = LoggerFactory.getLogger(FedoraDatastreamImpl.class);
    protected static final Property REST_API_DIGEST = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#digest");
    private boolean hasContent;
    private Node contentSubject;

    public FedoraDatastreamImpl(FedoraRepository repository, HttpHelper httpHelper, String path) {
        super(repository, httpHelper, path);
        this.contentSubject = NodeFactory.createURI((String)(repository.getRepositoryUrl() + path.substring(0, path.lastIndexOf("/"))));
    }

    @Override
    public void setGraph(Graph graph) {
        super.setGraph(graph);
        this.hasContent = this.getTriple(this.subject, RdfLexicon.DESCRIBES) != null;
    }

    public boolean hasContent() throws FedoraException {
        return this.hasContent;
    }

    public FedoraObject getObject() throws FedoraException {
        String contentPath = this.path.substring(0, this.path.lastIndexOf("/"));
        return this.repository.getObject(contentPath.substring(0, contentPath.lastIndexOf("/")));
    }

    @Override
    public String getName() {
        String p = this.path.endsWith("/") ? this.path.substring(0, this.path.length() - 1) : this.path;
        String[] paths = p.split("/");
        return paths[paths.length - 2];
    }

    public URI getContentDigest() throws FedoraException {
        Node contentDigest = this.getObjectValue(REST_API_DIGEST);
        try {
            if (contentDigest == null) {
                return null;
            }
            return new URI(contentDigest.getURI());
        }
        catch (URISyntaxException e) {
            throw new FedoraException("Error parsing checksum URI: " + contentDigest.getURI(), (Throwable)e);
        }
    }

    public Long getContentSize() throws FedoraException {
        Node size = this.getObjectValue(RdfLexicon.HAS_SIZE);
        if (size == null) {
            return null;
        }
        return new Long(size.getLiteralValue().toString());
    }

    public String getFilename() throws FedoraException {
        Node filename = this.getObjectValue(RdfLexicon.HAS_ORIGINAL_NAME);
        if (filename == null) {
            return null;
        }
        return filename.getLiteralValue().toString();
    }

    public String getContentType() throws FedoraException {
        Node contentType = this.getObjectValue(RdfLexicon.HAS_MIME_TYPE);
        if (contentType == null) {
            return null;
        }
        return contentType.getLiteralValue().toString();
    }

    public void updateContent(FedoraContent content) throws FedoraException {
        HttpPut put = this.httpHelper.createContentPutMethod(this.path, null, content);
        try {
            HttpResponse response = this.httpHelper.execute((HttpUriRequest)put);
            StatusLine status = response.getStatusLine();
            String uri = put.getURI().toString();
            if (status.getStatusCode() != 201 && status.getStatusCode() != 204) {
                if (status.getStatusCode() == 403) {
                    LOGGER.error("request for resource {} is not authorized.", (Object)uri);
                    throw new ForbiddenException("request for resource " + uri + " is not authorized.");
                }
                if (status.getStatusCode() == 404) {
                    LOGGER.error("resource {} does not exist, cannot retrieve", (Object)uri);
                    throw new NotFoundException("resource " + uri + " does not exist, cannot retrieve");
                }
                if (status.getStatusCode() == 409) {
                    LOGGER.error("checksum mismatch for {}", (Object)uri);
                    throw new FedoraException("checksum mismatch for resource " + uri);
                }
                LOGGER.error("error retrieving resource {}: {} {}", new Object[]{uri, status.getStatusCode(), status.getReasonPhrase()});
                throw new FedoraException("error retrieving resource " + uri + ": " + status.getStatusCode() + " " + status.getReasonPhrase());
            }
            LOGGER.debug("content updated successfully for resource {}", (Object)uri);
            this.httpHelper.loadProperties(this);
        }
        catch (FedoraException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("could not encode URI parameter", (Throwable)e);
            throw new FedoraException((Throwable)e);
        }
        finally {
            put.releaseConnection();
        }
    }

    public InputStream getContent() throws FedoraException {
        HttpGet get = this.httpHelper.createGetMethod(this.path, null);
        String uri = get.getURI().toString();
        try {
            HttpResponse response = this.httpHelper.execute((HttpUriRequest)get);
            StatusLine status = response.getStatusLine();
            if (status.getStatusCode() == 200) {
                InputStream inputStream = response.getEntity().getContent();
                return inputStream;
            }
            try {
                if (status.getStatusCode() == 403) {
                    LOGGER.error("request for resource {} is not authorized.", (Object)uri);
                    throw new ForbiddenException("request for resource " + uri + " is not authorized.");
                }
                if (status.getStatusCode() == 404) {
                    LOGGER.error("resource {} does not exist, cannot retrieve", (Object)uri);
                    throw new NotFoundException("resource " + uri + " does not exist, cannot retrieve");
                }
                LOGGER.error("error retrieving resource {}: {} {}", new Object[]{uri, status.getStatusCode(), status.getReasonPhrase()});
                throw new FedoraException("error retrieving resource " + uri + ": " + status.getStatusCode() + " " + status.getReasonPhrase());
            }
            catch (Exception e) {
                LOGGER.error("could not encode URI parameter", (Throwable)e);
                throw new FedoraException((Throwable)e);
            }
        }
        finally {
            get.releaseConnection();
        }
    }

    public void checkFixity() {
        throw new NotImplemented("Method checkFixity() is not implemented");
    }

    private Node getObjectValue(Property property) {
        if (!this.hasContent) {
            return null;
        }
        Triple t = this.getTriple(this.contentSubject, property);
        if (t == null) {
            return null;
        }
        return t.getObject();
    }
}

