/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.client.impl;

import java.io.InputStream;
import org.apache.http.client.HttpClient;
import org.fcrepo.client.FedoraContent;
import org.fcrepo.client.FedoraDatastream;
import org.fcrepo.client.FedoraException;
import org.fcrepo.client.FedoraObject;
import org.fcrepo.client.FedoraRepository;
import org.fcrepo.client.NotFoundException;
import org.fcrepo.client.ReadOnlyException;
import org.fcrepo.client.impl.FedoraRepositoryImpl;
import org.fcrepo.client.utils.HttpHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyFedoraRepositoryImpl
extends FedoraRepositoryImpl
implements FedoraRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadOnlyFedoraRepositoryImpl.class);
    private static final String msg = "Write operation attempted using read-only repository";

    public ReadOnlyFedoraRepositoryImpl(String repositoryURL) {
        this.repositoryURL = repositoryURL;
        this.httpHelper = new HttpHelper(repositoryURL, null, null, true);
    }

    public ReadOnlyFedoraRepositoryImpl(String repositoryURL, String username, String password) {
        this.repositoryURL = repositoryURL;
        this.httpHelper = new HttpHelper(repositoryURL, username, password, true);
    }

    public ReadOnlyFedoraRepositoryImpl(String repositoryURL, HttpClient httpClient) {
        this.repositoryURL = repositoryURL;
        this.httpHelper = new HttpHelper(repositoryURL, httpClient, true);
    }

    @Override
    public FedoraDatastream createDatastream(String path, FedoraContent content) throws ReadOnlyException {
        LOGGER.warn(msg);
        throw new ReadOnlyException();
    }

    @Override
    public FedoraObject createObject(String path) throws FedoraException {
        LOGGER.warn(msg);
        throw new ReadOnlyException();
    }

    @Override
    public FedoraDatastream findOrCreateDatastream(String path) throws FedoraException {
        try {
            return this.getDatastream(path);
        }
        catch (NotFoundException ex) {
            LOGGER.warn(msg);
            throw new ReadOnlyException();
        }
    }

    @Override
    public FedoraObject findOrCreateObject(String path) throws FedoraException {
        try {
            return this.getObject(path);
        }
        catch (NotFoundException ex) {
            LOGGER.warn(msg);
            throw new ReadOnlyException();
        }
    }

    @Override
    public void registerNodeTypes(InputStream cndStream) throws ReadOnlyException {
        LOGGER.warn(msg);
        throw new ReadOnlyException();
    }

    @Override
    public void addNamespace(String prefix, String uri) throws ReadOnlyException {
        LOGGER.warn(msg);
        throw new ReadOnlyException();
    }

    @Override
    public void removeNamespace(String prefix) throws ReadOnlyException {
        LOGGER.warn(msg);
        throw new ReadOnlyException();
    }

    @Override
    public boolean isWritable() {
        return false;
    }
}

