/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.client.impl;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.jena.atlas.lib.NotImplemented;
import org.fcrepo.client.FedoraException;
import org.fcrepo.client.FedoraRepository;
import org.fcrepo.client.FedoraResource;
import org.fcrepo.client.ForbiddenException;
import org.fcrepo.client.NotFoundException;
import org.fcrepo.client.ReadOnlyException;
import org.fcrepo.client.utils.HttpHelper;
import org.fcrepo.kernel.RdfLexicon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FedoraResourceImpl
implements FedoraResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(FedoraResourceImpl.class);
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    protected FedoraRepository repository = null;
    protected HttpHelper httpHelper = null;
    protected String path = null;
    protected Node subject = null;
    protected Graph graph;
    private String etagValue = null;

    public FedoraResourceImpl(FedoraRepository repository, HttpHelper httpHelper, String path) {
        this.repository = repository;
        this.httpHelper = httpHelper;
        this.path = path;
        this.subject = NodeFactory.createURI((String)(repository.getRepositoryUrl() + path));
    }

    public void copy(String destination) throws ReadOnlyException {
        throw new NotImplemented("Method copy(final String destination) is not implemented.");
    }

    public void delete() throws ReadOnlyException {
        throw new NotImplemented("Method delete() is not implemented.");
    }

    public Date getCreatedDate() {
        return this.getDate(RdfLexicon.CREATED_DATE);
    }

    public String getEtagValue() {
        return this.etagValue;
    }

    public void setEtagValue(String etagValue) {
        this.etagValue = etagValue;
    }

    public Date getLastModifiedDate() {
        return this.getDate(RdfLexicon.LAST_MODIFIED_DATE);
    }

    public Collection<String> getMixins() {
        return this.getPropertyValues(RdfLexicon.HAS_MIXIN_TYPE);
    }

    public String getName() {
        String p = this.path.endsWith("/") ? this.path.substring(0, this.path.length() - 1) : this.path;
        String[] paths = p.split("/");
        return paths[paths.length - 1];
    }

    public String getPath() {
        return this.path;
    }

    public Iterator<Triple> getProperties() {
        return this.graph.find(Node.ANY, Node.ANY, Node.ANY);
    }

    public Long getSize() {
        return this.graph.size();
    }

    public void move(String destination) throws ReadOnlyException {
        throw new NotImplemented("Method move(final String destination) is not implemented.");
    }

    public void updateProperties(String sparqlUpdate) throws FedoraException {
        HttpPatch patch = this.httpHelper.createPatchMethod(this.path, sparqlUpdate);
        try {
            HttpResponse response = this.httpHelper.execute((HttpUriRequest)patch);
            StatusLine status = response.getStatusLine();
            String uri = patch.getURI().toString();
            if (status.getStatusCode() != 204) {
                if (status.getStatusCode() == 403) {
                    LOGGER.error("updating resource {} is not authorized.", (Object)uri);
                    throw new ForbiddenException("updating resource " + uri + " is not authorized.");
                }
                if (status.getStatusCode() == 404) {
                    LOGGER.error("resource {} does not exist, cannot update", (Object)uri);
                    throw new NotFoundException("resource " + uri + " does not exist, cannot update");
                }
                if (status.getStatusCode() == 409) {
                    LOGGER.error("resource {} is locked", (Object)uri);
                    throw new FedoraException("resource is locked: " + uri);
                }
                LOGGER.error("error updating resource {}: {} {}", new Object[]{uri, status.getStatusCode(), status.getReasonPhrase()});
                throw new FedoraException("error updating resource " + uri + ": " + status.getStatusCode() + " " + status.getReasonPhrase());
            }
            LOGGER.debug("triples updated successfully for resource {}", (Object)uri);
            this.httpHelper.loadProperties(this);
        }
        catch (FedoraException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("could not encode URI parameter", (Throwable)e);
            throw new FedoraException((Throwable)e);
        }
        finally {
            patch.releaseConnection();
        }
    }

    public void updateProperties(InputStream updatedProperties, String contentType) throws FedoraException {
        HttpPut put = this.httpHelper.createTriplesPutMethod(this.path, updatedProperties, contentType);
        try {
            HttpResponse response = this.httpHelper.execute((HttpUriRequest)put);
            StatusLine status = response.getStatusLine();
            String uri = put.getURI().toString();
            if (status.getStatusCode() != 204) {
                if (status.getStatusCode() == 403) {
                    LOGGER.error("updating resource {} is not authorized.", (Object)uri);
                    throw new ForbiddenException("updating resource " + uri + " is not authorized.");
                }
                if (status.getStatusCode() == 404) {
                    LOGGER.error("resource {} does not exist, cannot update", (Object)uri);
                    throw new NotFoundException("resource " + uri + " does not exist, cannot update");
                }
                if (status.getStatusCode() == 409) {
                    LOGGER.error("resource {} is locked", (Object)uri);
                    throw new FedoraException("resource is locked: " + uri);
                }
                LOGGER.error("error updating resource {}: {} {}", new Object[]{uri, status.getStatusCode(), status.getReasonPhrase()});
                throw new FedoraException("error updating resource " + uri + ": " + status.getStatusCode() + " " + status.getReasonPhrase());
            }
            LOGGER.debug("triples updated successfully for resource {}", (Object)uri);
            this.httpHelper.loadProperties(this);
        }
        catch (FedoraException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("Error executing request", (Throwable)e);
            throw new FedoraException((Throwable)e);
        }
        finally {
            put.releaseConnection();
        }
    }

    public boolean isWritable() {
        Collection<String> values = this.getPropertyValues(RdfLexicon.WRITABLE);
        if (values != null && values.size() > 0) {
            Iterator<String> it = values.iterator();
            return Boolean.parseBoolean(it.next());
        }
        return false;
    }

    public void createVersionSnapshot(String label) throws FedoraException {
        block9: {
            HttpPost postVersion = this.httpHelper.createPostMethod(this.path + "/fcr:versions", null);
            try {
                postVersion.setHeader("Slug", label);
                HttpResponse response = this.httpHelper.execute((HttpUriRequest)postVersion);
                StatusLine status = response.getStatusLine();
                String uri = postVersion.getURI().toString();
                if (status.getStatusCode() == 204) {
                    LOGGER.debug("new version created for resource at {}", (Object)uri);
                    break block9;
                }
                if (status.getStatusCode() == 409) {
                    LOGGER.debug("The label {} is in use by another version.", (Object)label);
                    throw new FedoraException("The label \"" + label + "\" is in use by another version.");
                }
                if (status.getStatusCode() == 403) {
                    LOGGER.error("updating resource {} is not authorized.", (Object)uri);
                    throw new ForbiddenException("updating resource " + uri + " is not authorized.");
                }
                if (status.getStatusCode() == 404) {
                    LOGGER.error("resource {} does not exist, cannot create version", (Object)uri);
                    throw new NotFoundException("resource " + uri + " does not exist, cannot create version");
                }
                LOGGER.error("error updating resource {}: {} {}", new Object[]{uri, status.getStatusCode(), status.getReasonPhrase()});
                throw new FedoraException("error updating resource " + uri + ": " + status.getStatusCode() + " " + status.getReasonPhrase());
            }
            catch (IOException e) {
                LOGGER.error("Error executing request", (Throwable)e);
                throw new FedoraException((Throwable)e);
            }
            finally {
                postVersion.releaseConnection();
            }
        }
    }

    public Graph getGraph() {
        return this.graph;
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    private Date getDate(Property property) {
        Date date = null;
        Triple t = this.getTriple(this.subject, property);
        if (t != null) {
            String dateValue = t.getObject().getLiteralValue().toString();
            try {
                date = dateFormat.parse(dateValue);
            }
            catch (ParseException e) {
                LOGGER.debug("Invalid date format error: " + dateValue);
            }
        }
        return date;
    }

    protected Collection<String> getPropertyValues(Property property) {
        ExtendedIterator iterator = this.graph.find(Node.ANY, property.asNode(), Node.ANY);
        HashSet<String> set = new HashSet<String>();
        while (iterator.hasNext()) {
            Node object = ((Triple)iterator.next()).getObject();
            if (object.isLiteral()) {
                set.add(object.getLiteralValue().toString());
                continue;
            }
            if (object.isURI()) {
                set.add(object.getURI().toString());
                continue;
            }
            set.add(object.toString());
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Triple getTriple(Node subject, Property property) {
        try (ExtendedIterator it = this.graph.find(subject, property.asNode(), null);){
            if (it.hasNext()) {
                Triple triple = (Triple)it.next();
                return triple;
            }
            Triple triple = null;
            return triple;
        }
    }
}

