/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.client.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Collection;
import java.util.HashSet;
import org.fcrepo.client.FedoraException;
import org.fcrepo.client.FedoraObject;
import org.fcrepo.client.FedoraRepository;
import org.fcrepo.client.FedoraResource;
import org.fcrepo.client.impl.FedoraResourceImpl;
import org.fcrepo.client.utils.HttpHelper;
import org.fcrepo.kernel.RdfLexicon;

public class FedoraObjectImpl
extends FedoraResourceImpl
implements FedoraObject {
    private static final Node binaryType = NodeFactory.createLiteral((String)"fedora:binary");

    public FedoraObjectImpl(FedoraRepository repository, HttpHelper httpHelper, String path) {
        super(repository, httpHelper, path);
    }

    public Collection<FedoraResource> getChildren(String mixin) throws FedoraException {
        Node mixinLiteral = null;
        if (mixin != null) {
            mixinLiteral = NodeFactory.createLiteral((String)mixin);
        }
        ExtendedIterator it = this.graph.find(Node.ANY, RdfLexicon.CONTAINS.asNode(), Node.ANY);
        HashSet<FedoraResource> set = new HashSet<FedoraResource>();
        while (it.hasNext()) {
            Node child = ((Triple)it.next()).getObject();
            if (mixin != null && !this.graph.contains(child, RdfLexicon.HAS_MIXIN_TYPE.asNode(), mixinLiteral)) continue;
            String path = child.getURI().toString().replaceAll(this.repository.getRepositoryUrl(), "");
            if (this.graph.contains(child, RdfLexicon.HAS_MIXIN_TYPE.asNode(), binaryType)) {
                set.add((FedoraResource)this.repository.getDatastream(path));
                continue;
            }
            set.add((FedoraResource)this.repository.getObject(path));
        }
        return set;
    }
}

