/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.client.impl;

import com.hp.hpl.jena.graph.Triple;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.fcrepo.client.FedoraContent;
import org.fcrepo.client.FedoraDatastream;
import org.fcrepo.client.FedoraException;
import org.fcrepo.client.FedoraObject;
import org.fcrepo.client.FedoraRepository;
import org.fcrepo.client.ForbiddenException;
import org.fcrepo.client.NotFoundException;
import org.fcrepo.client.ReadOnlyException;
import org.fcrepo.client.impl.FedoraDatastreamImpl;
import org.fcrepo.client.impl.FedoraObjectImpl;
import org.fcrepo.client.utils.HttpHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FedoraRepositoryImpl
implements FedoraRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(FedoraRepositoryImpl.class);
    protected HttpHelper httpHelper;
    protected String repositoryURL;

    protected FedoraRepositoryImpl() {
    }

    public FedoraRepositoryImpl(String repositoryURL) {
        this(repositoryURL, null, null);
    }

    public FedoraRepositoryImpl(String repositoryURL, String username, String password) {
        this.repositoryURL = repositoryURL;
        this.httpHelper = new HttpHelper(repositoryURL, username, password, false);
    }

    public FedoraRepositoryImpl(String repositoryURL, HttpClient httpClient) {
        this.repositoryURL = repositoryURL;
        this.httpHelper = new HttpHelper(repositoryURL, httpClient, false);
    }

    public boolean exists(String path) throws FedoraException, ForbiddenException {
        HttpHead head = this.httpHelper.createHeadMethod(path);
        try {
            HttpResponse response = this.httpHelper.execute((HttpUriRequest)head);
            StatusLine status = response.getStatusLine();
            int statusCode = status.getStatusCode();
            String uri = head.getURI().toString();
            if (statusCode == 200) {
                boolean bl = true;
                return bl;
            }
            if (statusCode == 404) {
                boolean bl = false;
                return bl;
            }
            try {
                if (statusCode == 403) {
                    LOGGER.error("request for resource {} is not authorized.", (Object)uri);
                    throw new ForbiddenException("request for resource " + uri + " is not authorized.");
                }
                LOGGER.error("error checking resource {}: {} {}", new Object[]{uri, statusCode, status.getReasonPhrase()});
                throw new FedoraException("error checking resource " + uri + ": " + statusCode + " " + status.getReasonPhrase());
            }
            catch (Exception e) {
                LOGGER.error("could not encode URI parameter", (Throwable)e);
                throw new FedoraException((Throwable)e);
            }
        }
        finally {
            head.releaseConnection();
        }
    }

    public FedoraDatastream getDatastream(String path) throws FedoraException {
        return (FedoraDatastream)this.httpHelper.loadProperties(new FedoraDatastreamImpl(this, this.httpHelper, path));
    }

    public FedoraObject getObject(String path) throws FedoraException {
        return (FedoraObject)this.httpHelper.loadProperties(new FedoraObjectImpl(this, this.httpHelper, path));
    }

    public FedoraDatastream createDatastream(String path, FedoraContent content) throws FedoraException {
        HttpPut put = this.httpHelper.createContentPutMethod(path, null, content);
        try {
            HttpResponse response = this.httpHelper.execute((HttpUriRequest)put);
            String uri = put.getURI().toString();
            StatusLine status = response.getStatusLine();
            int statusCode = status.getStatusCode();
            if (statusCode == 201) {
                FedoraDatastream fedoraDatastream = this.getDatastream(path);
                return fedoraDatastream;
            }
            try {
                if (statusCode == 403) {
                    LOGGER.error("request to create resource {} is not authorized.", (Object)uri);
                    throw new ForbiddenException("request to create resource " + uri + " is not authorized.");
                }
                if (statusCode == 409) {
                    LOGGER.error("resource {} already exists", (Object)uri);
                    throw new FedoraException("resource " + uri + " already exists");
                }
                LOGGER.error("error creating resource {}: {} {}", new Object[]{uri, statusCode, status.getReasonPhrase()});
                throw new FedoraException("error retrieving resource " + uri + ": " + statusCode + " " + status.getReasonPhrase());
            }
            catch (Exception e) {
                LOGGER.error("could not encode URI parameter", (Throwable)e);
                throw new FedoraException((Throwable)e);
            }
        }
        finally {
            put.releaseConnection();
        }
    }

    public FedoraDatastream createOrUpdateRedirectDatastream(String path, String url) throws FedoraException {
        HttpPut put = this.httpHelper.createContentPutMethod(path, null, null);
        try {
            put.setHeader("Content-Type", "message/external-body; access-type=URL; URL=\"" + url + "\"");
            HttpResponse response = this.httpHelper.execute((HttpUriRequest)put);
            String uri = put.getURI().toString();
            StatusLine status = response.getStatusLine();
            int statusCode = status.getStatusCode();
            if (statusCode == 201) {
                FedoraDatastream fedoraDatastream = this.getDatastream(path);
                return fedoraDatastream;
            }
            try {
                if (statusCode == 403) {
                    LOGGER.error("request to create resource {} is not authorized.", (Object)uri);
                    throw new ForbiddenException("request to create resource " + uri + " is not authorized.");
                }
                LOGGER.error("error creating resource {}: {} {}", new Object[]{uri, statusCode, status.getReasonPhrase()});
                throw new FedoraException("error creating resource " + uri + ": " + statusCode + " " + status.getReasonPhrase());
            }
            catch (Exception e) {
                LOGGER.error("Error making or building PUT request.", (Throwable)e);
                throw new FedoraException((Throwable)e);
            }
        }
        finally {
            put.releaseConnection();
        }
    }

    public FedoraObject createObject(String path) throws FedoraException {
        HttpPut put = this.httpHelper.createPutMethod(path, null);
        try {
            HttpResponse response = this.httpHelper.execute((HttpUriRequest)put);
            String uri = put.getURI().toString();
            StatusLine status = response.getStatusLine();
            int statusCode = status.getStatusCode();
            if (statusCode == 201) {
                FedoraObject fedoraObject = this.getObject(path);
                return fedoraObject;
            }
            try {
                if (statusCode == 403) {
                    LOGGER.error("request to create resource {} is not authorized.", (Object)uri);
                    throw new ForbiddenException("request to create resource " + uri + " is not authorized.");
                }
                if (statusCode == 409) {
                    LOGGER.error("resource {} already exists", (Object)uri);
                    throw new FedoraException("resource " + uri + " already exists");
                }
                LOGGER.error("error creating resource {}: {} {}", new Object[]{uri, statusCode, status.getReasonPhrase()});
                throw new FedoraException("error retrieving resource " + uri + ": " + statusCode + " " + status.getReasonPhrase());
            }
            catch (Exception e) {
                LOGGER.error("could not encode URI parameter", (Throwable)e);
                throw new FedoraException((Throwable)e);
            }
        }
        finally {
            put.releaseConnection();
        }
    }

    public FedoraDatastream findOrCreateDatastream(String path) throws FedoraException {
        try {
            return this.getDatastream(path);
        }
        catch (NotFoundException ex) {
            return this.createDatastream(path, null);
        }
    }

    public FedoraObject findOrCreateObject(String path) throws FedoraException {
        try {
            return this.getObject(path);
        }
        catch (NotFoundException ex) {
            return this.createObject(path);
        }
    }

    public Iterator<Triple> getNodeTypes() {
        return null;
    }

    public void registerNodeTypes(InputStream cndStream) throws ReadOnlyException {
    }

    public Map<String, String> getRepositoryNamespaces() {
        return null;
    }

    public void addNamespace(String prefix, String uri) throws ReadOnlyException {
    }

    public void removeNamespace(String prefix) throws ReadOnlyException {
    }

    public Long getRepositoryObjectCount() {
        return null;
    }

    public Long getRepositorySize() {
        return null;
    }

    public boolean isWritable() {
        return true;
    }

    public String getRepositoryUrl() {
        return this.repositoryURL;
    }
}

