/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.client.utils;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.shared.RandomOrderGraph;
import java.util.Iterator;
import org.apache.jena.atlas.lib.Sink;
import org.apache.jena.riot.lang.SinkTriplesToGraph;
import org.apache.jena.riot.system.StreamRDFBase;

public class RDFSinkFilter
extends StreamRDFBase {
    private final Node[] properties;
    private final Sink<Triple> dest;

    private RDFSinkFilter(Sink<Triple> dest, Node ... properties) {
        this.dest = dest;
        this.properties = new Node[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            this.properties[i] = properties[i];
        }
    }

    public void triple(Triple triple) {
        for (Node p : this.properties) {
            if (Node.ANY != p && !triple.getPredicate().equals((Object)p)) continue;
            this.dest.send((Object)triple);
        }
    }

    public void finish() {
        this.dest.flush();
    }

    public static Graph filterTriples(Iterator<Triple> triples, Node ... properties) {
        RandomOrderGraph filteredGraph = new RandomOrderGraph(RandomOrderGraph.createDefaultGraph());
        SinkTriplesToGraph graphOutput = new SinkTriplesToGraph(true, (Graph)filteredGraph);
        RDFSinkFilter rdfFilter = new RDFSinkFilter((Sink<Triple>)graphOutput, properties);
        rdfFilter.start();
        while (triples.hasNext()) {
            Triple triple = triples.next();
            rdfFilter.triple(triple);
        }
        rdfFilter.finish();
        return filteredGraph;
    }
}

