/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.client.utils;

import com.hp.hpl.jena.graph.Node;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RiotReader;
import org.apache.jena.riot.lang.CollectorStreamTriples;
import org.apache.jena.riot.system.StreamRDF;
import org.fcrepo.client.BadRequestException;
import org.fcrepo.client.FedoraContent;
import org.fcrepo.client.FedoraException;
import org.fcrepo.client.FedoraObject;
import org.fcrepo.client.ForbiddenException;
import org.fcrepo.client.NotFoundException;
import org.fcrepo.client.ReadOnlyException;
import org.fcrepo.client.impl.FedoraResourceImpl;
import org.fcrepo.client.utils.HttpCopy;
import org.fcrepo.client.utils.HttpMove;
import org.fcrepo.client.utils.RDFSinkFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpHelper.class);
    private final String repositoryURL;
    private final HttpClient httpClient;
    private final boolean readOnly;

    public HttpHelper(String repositoryURL, HttpClient httpClient, boolean readOnly) {
        this.repositoryURL = repositoryURL;
        this.httpClient = httpClient;
        this.readOnly = readOnly;
    }

    public HttpHelper(String repositoryURL, String fedoraUsername, String fedoraPassword, boolean readOnly) {
        this.repositoryURL = repositoryURL;
        this.readOnly = readOnly;
        PoolingClientConnectionManager connMann = new PoolingClientConnectionManager();
        connMann.setMaxTotal(Integer.MAX_VALUE);
        connMann.setDefaultMaxPerRoute(Integer.MAX_VALUE);
        DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)connMann);
        httpClient.setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy());
        httpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new StandardHttpRequestRetryHandler(0, false));
        if (!StringUtils.isBlank((CharSequence)fedoraUsername) && !StringUtils.isBlank((CharSequence)fedoraPassword)) {
            LOGGER.debug("Adding BASIC credentials to client for repo requests.");
            URI fedoraUri = URI.create(repositoryURL);
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(fedoraUri.getHost(), fedoraUri.getPort()), (Credentials)new UsernamePasswordCredentials(fedoraUsername, fedoraPassword));
            httpClient.setCredentialsProvider((CredentialsProvider)credsProvider);
        }
        this.httpClient = httpClient;
    }

    public HttpResponse execute(HttpUriRequest request) throws IOException, ReadOnlyException {
        if (this.readOnly) {
            switch (request.getMethod().toLowerCase()) {
                case "copy": 
                case "delete": 
                case "move": 
                case "patch": 
                case "post": 
                case "put": {
                    throw new ReadOnlyException();
                }
            }
        }
        return this.httpClient.execute(request);
    }

    private static String queryString(Map<String, List<String>> params) {
        StringBuilder builder = new StringBuilder();
        if (params != null && params.size() > 0) {
            for (String key : params.keySet()) {
                List<String> values = params.get(key);
                for (String value : values) {
                    try {
                        builder.append(key + "=" + URLEncoder.encode(value, "UTF-8") + "&");
                    }
                    catch (UnsupportedEncodingException e) {
                        builder.append(key + "=" + value + "&");
                    }
                }
            }
            return builder.length() > 0 ? "?" + builder.substring(0, builder.length() - 1) : "";
        }
        return "";
    }

    public HttpHead createHeadMethod(String path) {
        return new HttpHead(this.repositoryURL + path);
    }

    public HttpGet createGetMethod(String path, Map<String, List<String>> params) {
        return new HttpGet(this.repositoryURL + path + HttpHelper.queryString(params));
    }

    public HttpDelete createDeleteMethod(String path) {
        return new HttpDelete(this.repositoryURL + path);
    }

    public HttpPatch createPatchMethod(String path, String sparqlUpdate) throws FedoraException {
        if (StringUtils.isBlank((CharSequence)sparqlUpdate)) {
            throw new FedoraException("SPARQL Update command must not be blank");
        }
        HttpPatch patch = new HttpPatch(this.repositoryURL + path);
        patch.setEntity((HttpEntity)new ByteArrayEntity(sparqlUpdate.getBytes()));
        patch.setHeader("Content-Type", "application/sparql-update");
        return patch;
    }

    public HttpPost createPostMethod(String path, Map<String, List<String>> params) {
        return new HttpPost(this.repositoryURL + path + HttpHelper.queryString(params));
    }

    public HttpPut createPutMethod(String path, Map<String, List<String>> params) {
        return new HttpPut(this.repositoryURL + path + HttpHelper.queryString(params));
    }

    public HttpPut createContentPutMethod(String path, Map<String, List<String>> params, FedoraContent content) {
        String contentPath = path;
        if (content != null && content.getChecksum() != null) {
            contentPath = contentPath + "?checksum=" + content.getChecksum();
        }
        HttpPut put = this.createPutMethod(contentPath, params);
        if (content != null) {
            put.setEntity((HttpEntity)new InputStreamEntity(content.getContent()));
        }
        if (content != null && content.getFilename() != null) {
            put.setHeader("Content-Disposition", "attachment; filename=\"" + content.getFilename() + "\"");
        }
        if (content != null && content.getContentType() != null) {
            put.setHeader("Content-Type", content.getContentType());
        }
        return put;
    }

    public HttpPut createTriplesPutMethod(String path, InputStream updatedProperties, String contentType) throws FedoraException {
        if (updatedProperties == null) {
            throw new FedoraException("updatedProperties must not be null");
        }
        if (StringUtils.isBlank((CharSequence)contentType)) {
            throw new FedoraException("contentType must not be blank");
        }
        HttpPut put = new HttpPut(this.repositoryURL + path);
        put.setEntity((HttpEntity)new InputStreamEntity(updatedProperties));
        put.setHeader("Content-Type", contentType);
        return put;
    }

    public FedoraResourceImpl loadProperties(FedoraResourceImpl resource) throws FedoraException {
        String path = resource.getPropertiesPath();
        HttpGet get = this.createGetMethod(path, null);
        if (resource instanceof FedoraObject) {
            get.addHeader("Prefer", "return=representation; include=\"http://fedora.info/definitions/v4/repository#EmbedResources\"");
        }
        try {
            get.setHeader("accept", "application/rdf+xml");
            HttpResponse response = this.execute((HttpUriRequest)get);
            String uri = get.getURI().toString();
            StatusLine status = response.getStatusLine();
            if (status.getStatusCode() == 200) {
                LOGGER.debug("Updated properties for resource {}", (Object)uri);
                Header[] etagHeader = response.getHeaders("ETag");
                if (etagHeader != null && etagHeader.length > 0) {
                    resource.setEtagValue(etagHeader[0].getValue());
                }
                HttpEntity entity = response.getEntity();
                Lang lang = RDFLanguages.contentTypeToLang((String)entity.getContentType().getValue().split(":")[0]);
                CollectorStreamTriples streamTriples = new CollectorStreamTriples();
                RiotReader.parse((InputStream)entity.getContent(), (Lang)lang, (String)uri, (StreamRDF)streamTriples);
                resource.setGraph(RDFSinkFilter.filterTriples(streamTriples.getCollected().iterator(), Node.ANY));
                FedoraResourceImpl fedoraResourceImpl = resource;
                return fedoraResourceImpl;
            }
            try {
                if (status.getStatusCode() == 403) {
                    LOGGER.info("request for resource {} is not authorized.", (Object)uri);
                    throw new ForbiddenException("request for resource " + uri + " is not authorized.");
                }
                if (status.getStatusCode() == 400) {
                    LOGGER.info("server does not support metadata type application/rdf+xml for resource {}  cannot retrieve", (Object)uri);
                    throw new BadRequestException("server does not support the request metadata type for resource " + uri);
                }
                if (status.getStatusCode() == 404) {
                    LOGGER.info("resource {} does not exist, cannot retrieve", (Object)uri);
                    throw new NotFoundException("resource " + uri + " does not exist, cannot retrieve");
                }
                LOGGER.info("unexpected status code ({}) when retrieving resource {}", (Object)status.getStatusCode(), (Object)uri);
                throw new FedoraException("error retrieving resource " + uri + ": " + status.getStatusCode() + " " + status.getReasonPhrase());
            }
            catch (FedoraException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.info("could not encode URI parameter", (Throwable)e);
                throw new FedoraException((Throwable)e);
            }
        }
        finally {
            get.releaseConnection();
        }
    }

    public HttpCopy createCopyMethod(String sourcePath, String destinationPath) {
        return new HttpCopy(this.repositoryURL + sourcePath, this.repositoryURL + destinationPath);
    }

    public HttpMove createMoveMethod(String sourcePath, String destinationPath) {
        return new HttpMove(this.repositoryURL + sourcePath, this.repositoryURL + destinationPath);
    }
}

