/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.client.messaging;

import java.net.ConnectException;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;
import org.fcrepo.client.messaging.MessagingClient;
import org.fcrepo.client.messaging.MessagingListener;
import org.fcrepo.server.errors.MessagingException;
import org.fcrepo.server.messaging.JMSManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsMessagingClient
implements MessagingClient,
MessageListener {
    private static final int MAX_RETRIES = 5;
    private static final int RETRY_INTERVAL = 20000;
    private static final Logger logger = LoggerFactory.getLogger(JmsMessagingClient.class);
    private final String m_clientId;
    private final MessagingListener m_listener;
    private final Properties m_connectionProperties;
    private final String m_messageSelector;
    private final boolean m_durable;
    private JMSManager m_jmsManager = null;
    private boolean m_connected = false;

    public JmsMessagingClient(String clientId, MessagingListener listener, Properties connectionProperties) throws MessagingException {
        this(clientId, listener, connectionProperties, "", false);
    }

    public JmsMessagingClient(String clientId, MessagingListener listener, Properties connectionProperties, boolean durable) throws MessagingException {
        this(clientId, listener, connectionProperties, "", durable);
    }

    public JmsMessagingClient(String clientId, MessagingListener listener, Properties connectionProperties, String messageSelector, boolean durable) throws MessagingException {
        if (listener == null) {
            throw new MessagingException("MessageListener may not be null");
        }
        if (connectionProperties == null) {
            throw new MessagingException("Connection properties may not be null");
        }
        String initialContextFactory = connectionProperties.getProperty("java.naming.factory.initial");
        String providerUrl = connectionProperties.getProperty("java.naming.provider.url");
        String connectionFactoryName = connectionProperties.getProperty("connection.factory.name");
        if (initialContextFactory == null || providerUrl == null || connectionFactoryName == null) {
            throw new MessagingException("Propery values for 'java.naming.factory.initial', 'java.naming.provider.url', and'connection.factory.name' must be provided in order to initialize a messaging client");
        }
        if (durable && (clientId == null || clientId.equals(""))) {
            throw new MessagingException("ClientId must be specified for durable subscriptions");
        }
        this.m_clientId = clientId;
        this.m_listener = listener;
        this.m_connectionProperties = connectionProperties;
        this.m_messageSelector = messageSelector;
        this.m_durable = durable;
    }

    @Override
    public void start() throws MessagingException {
        this.start(true);
    }

    public void start(boolean wait) throws MessagingException {
        JMSBrokerConnector connector = new JMSBrokerConnector();
        connector.start();
        if (wait) {
            int maxWait = 100000;
            int waitTime = 0;
            while (!this.isConnected()) {
                if (waitTime < maxWait) {
                    try {
                        Thread.sleep(100L);
                        waitTime += 100;
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                throw new MessagingException("Timeout reached waiting for messaging client to start.");
            }
        }
    }

    public boolean isConnected() {
        return this.m_connected;
    }

    private void createDestinations() throws MessagingException {
        try {
            Enumeration<Object> propertyNames = this.m_connectionProperties.keys();
            while (propertyNames.hasMoreElements()) {
                String destinationName;
                String propertyName = (String)propertyNames.nextElement();
                if (propertyName.startsWith("topic.")) {
                    destinationName = this.m_connectionProperties.getProperty(propertyName);
                    this.m_jmsManager.createDestination(destinationName, JMSManager.DestinationType.Topic);
                    continue;
                }
                if (!propertyName.startsWith("queue.")) continue;
                destinationName = this.m_connectionProperties.getProperty(propertyName);
                this.m_jmsManager.createDestination(destinationName, JMSManager.DestinationType.Queue);
            }
            List destinations = this.m_jmsManager.getDestinations();
            if (destinations.size() == 0) {
                throw new MessagingException("No destinations available for subscription, make sure that there is at least one topic or queue specified in the connection properties.");
            }
            for (Destination destination : destinations) {
                if (this.m_durable && destination instanceof Topic) {
                    this.m_jmsManager.listenDurable((Topic)destination, this.m_messageSelector, (MessageListener)this, null);
                    continue;
                }
                this.m_jmsManager.listen(destination, this.m_messageSelector, (MessageListener)this);
            }
        }
        catch (MessagingException me) {
            logger.error("MessagingException encountered attempting to start Messaging Client: " + this.m_clientId + ". Exception message: " + me.getMessage(), (Throwable)me);
            throw me;
        }
    }

    @Override
    public void stop(boolean unsubscribe) throws MessagingException {
        try {
            if (unsubscribe) {
                this.m_jmsManager.unsubscribeAllDurable();
            }
            this.m_jmsManager.close();
            this.m_jmsManager = null;
            this.m_connected = false;
        }
        catch (MessagingException me) {
            logger.error("Messaging Exception encountered attempting to stop Messaging Client: " + this.m_clientId + ". Exception message: " + me.getMessage(), (Throwable)me);
            throw me;
        }
    }

    public void onMessage(Message message) {
        this.m_listener.onMessage(this.m_clientId, message);
    }

    private class JMSBrokerConnector
    extends Thread {
        private JMSBrokerConnector() {
        }

        @Override
        public void run() {
            try {
                this.connect();
                JmsMessagingClient.this.createDestinations();
                JmsMessagingClient.this.m_connected = true;
            }
            catch (MessagingException me) {
                throw new RuntimeException(me);
            }
        }

        private void connect() throws MessagingException {
            int retries = 0;
            while (JmsMessagingClient.this.m_jmsManager == null && retries < 5) {
                try {
                    JmsMessagingClient.this.m_jmsManager = new JMSManager(JmsMessagingClient.this.m_connectionProperties, JmsMessagingClient.this.m_clientId);
                }
                catch (MessagingException me) {
                    Throwable rootCause = me.getCause();
                    while (rootCause.getCause() != null) {
                        rootCause = rootCause.getCause();
                    }
                    if (rootCause instanceof ConnectException) {
                        try {
                            JMSBrokerConnector.sleep(20000L);
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                        }
                        ++retries;
                        continue;
                    }
                    throw me;
                }
            }
            if (JmsMessagingClient.this.m_jmsManager == null) {
                String errorMessage = "Unable to start JMS Messaging Client, 5 attempts were made, each attempt resulted in a java.net.ConnectException. The messaging broker at " + JmsMessagingClient.this.m_connectionProperties.getProperty("java.naming.provider.url") + " is not available";
                throw new RuntimeException(errorMessage);
            }
        }
    }
}

