/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.connector.file;

import java.io.File;
import java.util.Map;
import org.fcrepo.kernel.utils.ContentDigest;
import org.infinispan.schematic.document.Document;
import org.modeshape.connector.filesystem.FileSystemConnector;
import org.modeshape.jcr.federation.spi.Connector;
import org.modeshape.jcr.federation.spi.DocumentReader;
import org.modeshape.jcr.federation.spi.DocumentWriter;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FedoraFileSystemConnector
extends FileSystemConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(FedoraFileSystemConnector.class);

    public Document getDocumentById(String id) {
        LOGGER.debug("Getting Federated document: {}", (Object)id);
        if (null == id || id.isEmpty()) {
            LOGGER.warn("Can not get document with null id");
            return null;
        }
        Document doc = super.getDocumentById(id);
        DocumentReader docReader = this.readDocument(doc);
        DocumentWriter docWriter = this.writeDocument(doc);
        String primaryType = docReader.getPrimaryTypeName();
        if (!docReader.getMixinTypeNames().contains("fedora:resource")) {
            LOGGER.trace("Adding mixin: {}, to {}", (Object)"fedora:resource", (Object)id);
            docWriter.addMixinType("fedora:resource");
        }
        if (primaryType.equals("nt:file")) {
            FedoraFileSystemConnector.decorateDatastreamNode(docReader, docWriter);
        } else if (primaryType.equals("nt:resource")) {
            FedoraFileSystemConnector.decorateContentNode(docReader, docWriter);
        }
        if (!this.isReadonly()) {
            this.saveProperties(docReader);
        }
        return docWriter.document();
    }

    public String sha1(File file) {
        String id = this.idFor(file);
        Document doc = super.getDocumentById(id);
        DocumentReader docReader = this.readDocument(doc);
        if (null != docReader.getProperty("fedora:digest")) {
            return docReader.getProperty("fedora:digest").toString();
        }
        return super.sha1(file);
    }

    private static void decorateDatastreamNode(DocumentReader docReader, DocumentWriter docWriter) {
        if (!docReader.getMixinTypeNames().contains("fedora:datastream")) {
            LOGGER.trace("Adding mixin: {}, to {}", (Object)"fedora:datastream", (Object)docReader.getDocumentId());
            docWriter.addMixinType("fedora:datastream");
        }
    }

    private static void decorateContentNode(DocumentReader docReader, DocumentWriter docWriter) {
        BinaryValue binaryValue;
        if (!docReader.getMixinTypeNames().contains("fedora:binary")) {
            LOGGER.trace("Adding mixin: {}, to {}", (Object)"fedora:binary", (Object)docReader.getDocumentId());
            docWriter.addMixinType("fedora:binary");
        }
        if (null == docReader.getProperty("fedora:digest")) {
            binaryValue = FedoraFileSystemConnector.getBinaryValue(docReader);
            String dsChecksum = binaryValue.getHexHash();
            String dsURI = ContentDigest.asURI((String)"SHA-1", (String)dsChecksum).toString();
            LOGGER.trace("Adding {} property of {} to {}", new Object[]{"fedora:digest", dsURI, docReader.getDocumentId()});
            docWriter.addProperty("fedora:digest", (Object)dsURI);
        }
        if (null == docReader.getProperty("premis:hasSize")) {
            binaryValue = FedoraFileSystemConnector.getBinaryValue(docReader);
            long binarySize = binaryValue.getSize();
            LOGGER.trace("Adding {} property of {} to {}", new Object[]{"premis:hasSize", binarySize, docReader.getDocumentId()});
            docWriter.addProperty("premis:hasSize", (Object)binarySize);
        }
        LOGGER.debug("Decorated data property at path: {}", (Object)docReader.getDocumentId());
    }

    private static BinaryValue getBinaryValue(DocumentReader docReader) {
        Property binaryProperty = docReader.getProperty("jcr:data");
        return (BinaryValue)binaryProperty.getFirstValue();
    }

    private void saveProperties(DocumentReader docReader) {
        LOGGER.trace("Persisting properties for {}", (Object)docReader.getDocumentId());
        Map properties = docReader.getProperties();
        Connector.ExtraProperties extraProperties = this.extraPropertiesFor(docReader.getDocumentId(), true);
        extraProperties.addAll(properties).except(new String[]{"jcr:primaryType", "jcr:created", "jcr:lastModified", "jcr:data"});
        extraProperties.save();
    }
}

