/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.connector.file;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import org.fcrepo.kernel.utils.ContentDigest;
import org.infinispan.schematic.document.Document;
import org.modeshape.connector.filesystem.ExternalJsonSidecarExtraPropertyStore;
import org.modeshape.connector.filesystem.FileSystemConnector;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.spi.federation.DocumentChanges;
import org.modeshape.jcr.spi.federation.DocumentReader;
import org.modeshape.jcr.spi.federation.DocumentWriter;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Property;
import org.modeshape.jcr.value.basic.BasicSingleValueProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FedoraFileSystemConnector
extends FileSystemConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(FedoraFileSystemConnector.class);
    private static final String DELIMITER = "/";
    private static final String JCR_CONTENT = "jcr:content";
    private static final String JCR_CONTENT_SUFFIX = "/jcr:content";
    private String propertiesDirectoryPath;
    private File propertiesDirectory;

    @Override
    public void initialize(NamespaceRegistry registry, NodeTypeManager nodeTypeManager) throws RepositoryException, IOException {
        super.initialize(registry, nodeTypeManager);
        if (this.propertiesDirectoryPath != null) {
            this.propertiesDirectory = new File(this.propertiesDirectoryPath);
            if (!this.propertiesDirectory.exists() || !this.propertiesDirectory.isDirectory()) {
                throw new RepositoryException("Configured \"propertiesDirectory\", " + this.propertiesDirectoryPath + ", does not exist or is not a directory.");
            }
            if (!this.propertiesDirectory.canRead() || !this.propertiesDirectory.canWrite()) {
                throw new RepositoryException("Configured \"propertiesDirectory\", " + this.propertiesDirectoryPath + ", should be readable and writable.");
            }
            if (this.extraPropertiesStore() != null) {
                LOGGER.warn("Extra properties store was specified but won't be used!");
            }
            this.setExtraPropertiesStore(new ExternalJsonSidecarExtraPropertyStore(this, this.translator(), this.propertiesDirectory));
        }
    }

    @Override
    public Document getDocumentById(String id) {
        LOGGER.debug("Getting Federated document: {}", (Object)id);
        if (null == id || id.isEmpty()) {
            LOGGER.warn("Can not get document with null id");
            return null;
        }
        Document doc = super.getDocumentById(id);
        if (doc == null) {
            LOGGER.debug("Non-existent node, document is null: {}", (Object)id);
            return doc;
        }
        DocumentReader docReader = this.readDocument(doc);
        DocumentWriter docWriter = this.writeDocument(doc);
        long lastmod = this.fileFor(id).lastModified();
        LOGGER.debug("Adding lastModified={}", (Object)lastmod);
        docWriter.addProperty("jcr:lastModified", (Object)lastmod);
        String primaryType = docReader.getPrimaryTypeName();
        if (!docReader.getMixinTypeNames().contains("fedora:Resource")) {
            LOGGER.trace("Adding mixin: {}, to {}", (Object)"fedora:Resource", (Object)id);
            docWriter.addMixinType("fedora:Resource");
        }
        if (primaryType.equals("nt:file")) {
            FedoraFileSystemConnector.decorateDatastreamNode(docReader, docWriter);
        } else if (primaryType.equals("nt:resource")) {
            FedoraFileSystemConnector.decorateContentNode(docReader, docWriter, this.fileFor(id));
        } else if (primaryType.equals("nt:folder")) {
            FedoraFileSystemConnector.decorateObjectNode(docReader, docWriter);
        }
        return docWriter.document();
    }

    protected boolean shouldCacheProperties() {
        return this.extraPropertiesStore() != null && (!this.isReadonly() || this.propertiesDirectory != null);
    }

    @Override
    public String sha1(File file) {
        String cachedSha1 = this.getCachedSha1(file);
        if (cachedSha1 == null) {
            return this.computeAndCacheSha1(file);
        }
        return cachedSha1;
    }

    private String getCachedSha1(File file) {
        String id = this.idFor(file) + JCR_CONTENT_SUFFIX;
        if (this.extraPropertiesStore() != null) {
            Name digestName;
            Map extraProperties = this.extraPropertiesStore().getProperties(id);
            if (extraProperties.containsKey(digestName = this.nameFrom("fedora:digest")) && !FedoraFileSystemConnector.hasBeenModifiedSincePropertiesWereStored(file, (Property)extraProperties.get(this.nameFrom("jcr:created")))) {
                LOGGER.trace("Found sha1 for {} in extra properties store.", (Object)id);
                String uriStr = ((URI)((Property)extraProperties.get(digestName)).getFirstValue()).toString();
                return uriStr.substring(uriStr.indexOf("sha1:") + 5);
            }
        } else {
            LOGGER.trace("No cache configured to contain object hashes.");
        }
        return null;
    }

    private String computeAndCacheSha1(File file) {
        String id = this.idFor(file) + JCR_CONTENT_SUFFIX;
        LOGGER.trace("Computing sha1 for {}.", (Object)id);
        String sha1 = super.sha1(file);
        if (this.shouldCacheProperties()) {
            HashMap<Name, BasicSingleValueProperty> updateMap = new HashMap<Name, BasicSingleValueProperty>();
            BasicSingleValueProperty digestProperty = new BasicSingleValueProperty(this.nameFrom("fedora:digest"), (Object)ContentDigest.asURI((String)"SHA-1", (String)sha1));
            BasicSingleValueProperty digestDateProperty = new BasicSingleValueProperty(this.nameFrom("jcr:created"), this.factories().getDateFactory().create(file.lastModified()));
            updateMap.put(digestProperty.getName(), digestProperty);
            updateMap.put(digestDateProperty.getName(), digestDateProperty);
            this.extraPropertiesStore().updateProperties(id, updateMap);
        }
        return sha1;
    }

    private static void decorateObjectNode(DocumentReader docReader, DocumentWriter docWriter) {
        if (!docReader.getMixinTypeNames().contains("fedora:Container")) {
            LOGGER.trace("Adding mixin: {}, to {}", (Object)"fedora:Container", (Object)docReader.getDocumentId());
            docWriter.addMixinType("fedora:Container");
        }
    }

    private static void decorateDatastreamNode(DocumentReader docReader, DocumentWriter docWriter) {
        if (!docReader.getMixinTypeNames().contains("fedora:NonRdfSourceDescription")) {
            LOGGER.trace("Adding mixin: {}, to {}", (Object)"fedora:NonRdfSourceDescription", (Object)docReader.getDocumentId());
            docWriter.addMixinType("fedora:NonRdfSourceDescription");
        }
    }

    private static void decorateContentNode(DocumentReader docReader, DocumentWriter docWriter, File file) {
        if (!docReader.getMixinTypeNames().contains("fedora:Binary")) {
            LOGGER.trace("Adding mixin: {}, to {}", (Object)"fedora:Binary", (Object)docReader.getDocumentId());
            docWriter.addMixinType("fedora:Binary");
        }
        if (null == docReader.getProperty("fedora:digest") || FedoraFileSystemConnector.hasBeenModifiedSincePropertiesWereStored(file, docReader.getProperty("jcr:created"))) {
            BinaryValue binaryValue = FedoraFileSystemConnector.getBinaryValue(docReader);
            String dsChecksum = binaryValue.getHexHash();
            String dsURI = ContentDigest.asURI((String)"SHA-1", (String)dsChecksum).toString();
            LOGGER.trace("Adding {} property of {} to {}", new Object[]{"fedora:digest", dsURI, docReader.getDocumentId()});
            docWriter.addProperty("fedora:digest", (Object)dsURI);
        }
        if (null == docReader.getProperty("premis:hasSize")) {
            long binarySize = file.length();
            LOGGER.trace("Adding {} property of {} to {}", new Object[]{"premis:hasSize", binarySize, docReader.getDocumentId()});
            docWriter.addProperty("premis:hasSize", (Object)binarySize);
        }
        LOGGER.debug("Decorated data property at path: {}", (Object)docReader.getDocumentId());
    }

    private static boolean hasBeenModifiedSincePropertiesWereStored(File file, Property lastModified) {
        if (lastModified == null) {
            LOGGER.trace("Hash for {} has not been computed yet.", (Object)file.getName());
            return true;
        }
        DateTime datetime = (DateTime)lastModified.getFirstValue();
        if (datetime.toDate().equals(new Date(file.lastModified()))) {
            return false;
        }
        LOGGER.trace("{} has been modified ({}) since hash was last computed ({}).", new Object[]{file.getName(), new Date(file.lastModified()), datetime.toDate()});
        return true;
    }

    private static BinaryValue getBinaryValue(DocumentReader docReader) {
        Property binaryProperty = docReader.getProperty("jcr:data");
        return (BinaryValue)binaryProperty.getFirstValue();
    }

    @Override
    public boolean removeDocument(String id) {
        if (super.removeDocument(id)) {
            this.touchParent(id);
            return true;
        }
        return false;
    }

    @Override
    public void storeDocument(Document document) {
        super.storeDocument(document);
        this.touchParent(this.readDocument(document).getDocumentId());
    }

    @Override
    public void updateDocument(DocumentChanges changes) {
        super.updateDocument(changes);
        this.touchParent(changes.getDocumentId());
    }

    protected void touchParent(String id) {
        if (!this.isRoot(id)) {
            File file = this.fileFor(id);
            File parent = file.getParentFile();
            parent.setLastModified(System.currentTimeMillis());
        }
    }

    @Override
    @VisibleForTesting
    protected File fileFor(String id) {
        return super.fileFor(id);
    }

    @VisibleForTesting
    protected DocumentReader readDocument(Document document) {
        return super.readDocument(document);
    }

    public boolean isReadonly() {
        return true;
    }
}

