/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.filesystem;

import java.io.File;
import java.nio.file.Path;
import org.modeshape.connector.filesystem.FileSystemConnector;
import org.modeshape.connector.filesystem.JsonSidecarExtraPropertyStore;
import org.modeshape.jcr.cache.document.DocumentTranslator;

public class ExternalJsonSidecarExtraPropertyStore
extends JsonSidecarExtraPropertyStore {
    private FileSystemConnector connector;
    private File propertyStoreRoot;

    public ExternalJsonSidecarExtraPropertyStore(FileSystemConnector connector, DocumentTranslator translator, File propertyStoreRoot) {
        super(connector, translator);
        this.connector = connector;
        this.propertyStoreRoot = propertyStoreRoot;
    }

    @Override
    protected File sidecarFile(String id) {
        File file;
        if (this.connector.isRoot(id)) {
            file = new File(this.propertyStoreRoot, "federation-root.modeshape.json");
        } else {
            Path propertyFileInFederation = super.sidecarFile(id).getAbsoluteFile().toPath();
            Path relativePath = this.connector.fileFor("/").getAbsoluteFile().toPath().relativize(propertyFileInFederation);
            file = this.propertyStoreRoot.toPath().resolve(relativePath).toFile();
        }
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new RuntimeException("Unable to create directories " + file.getParentFile() + ".");
        }
        return file;
    }
}

