/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.filesystem;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.schematic.Schematic;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.EditableDocument;
import org.infinispan.schematic.document.Json;
import org.modeshape.connector.filesystem.FileSystemConnector;
import org.modeshape.jcr.cache.DocumentStoreException;
import org.modeshape.jcr.cache.document.DocumentTranslator;
import org.modeshape.jcr.spi.federation.ExtraPropertiesStore;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Property;

class JsonSidecarExtraPropertyStore
implements ExtraPropertiesStore {
    public static final String DEFAULT_EXTENSION = ".modeshape.json";
    public static final String DEFAULT_RESOURCE_EXTENSION = ".content.modeshape.json";
    private final FileSystemConnector connector;
    private final DocumentTranslator translator;

    protected JsonSidecarExtraPropertyStore(FileSystemConnector connector, DocumentTranslator translator) {
        this.connector = connector;
        this.translator = translator;
    }

    protected String getExclusionPattern() {
        return "(.+)\\.(content\\.)?modeshape\\.json$";
    }

    public Map<Name, Property> getProperties(String id) {
        File sidecarFile = this.sidecarFile(id);
        if (!sidecarFile.exists()) {
            return NO_PROPERTIES;
        }
        try {
            Document document = this.read(new FileInputStream(sidecarFile));
            HashMap<Name, Property> results = new HashMap<Name, Property>();
            this.translator.getProperties(document, results);
            return results;
        }
        catch (IOException e) {
            throw new DocumentStoreException(id, (Throwable)e);
        }
    }

    public void updateProperties(String id, Map<Name, Property> properties) {
        File sidecarFile = this.sidecarFile(id);
        try {
            EditableDocument document = null;
            if (!sidecarFile.exists()) {
                if (properties.isEmpty()) {
                    return;
                }
                sidecarFile.createNewFile();
                document = Schematic.newDocument();
            } else {
                Document existing = this.read(new FileInputStream(sidecarFile));
                document = Schematic.newDocument((Document)existing);
            }
            for (Map.Entry<Name, Property> entry : properties.entrySet()) {
                Property property = entry.getValue();
                if (property == null) {
                    this.translator.removeProperty(document, entry.getKey(), null, null);
                    continue;
                }
                this.translator.setProperty(document, property, null, null);
            }
            this.write((Document)document, new FileOutputStream(sidecarFile));
        }
        catch (IOException e) {
            throw new DocumentStoreException(id, (Throwable)e);
        }
    }

    public void storeProperties(String id, Map<Name, Property> properties) {
        File sidecarFile = this.sidecarFile(id);
        try {
            if (!sidecarFile.exists()) {
                if (properties.isEmpty()) {
                    return;
                }
                sidecarFile.createNewFile();
            }
            EditableDocument document = Schematic.newDocument();
            for (Property property : properties.values()) {
                if (property == null) continue;
                this.translator.setProperty(document, property, null, null);
            }
            this.write((Document)document, new FileOutputStream(sidecarFile));
        }
        catch (IOException e) {
            throw new DocumentStoreException(id, (Throwable)e);
        }
    }

    protected Document read(InputStream stream) throws IOException {
        return Json.read((InputStream)stream, (boolean)false);
    }

    protected void write(Document document, OutputStream stream) throws IOException {
        Json.write((Document)document, (OutputStream)stream);
    }

    protected String extension() {
        return DEFAULT_EXTENSION;
    }

    protected String resourceExtension() {
        return DEFAULT_RESOURCE_EXTENSION;
    }

    public boolean removeProperties(String id) {
        File file = this.sidecarFile(id);
        if (!file.exists()) {
            return false;
        }
        file.delete();
        return true;
    }

    protected File sidecarFile(String id) {
        File actualFile = this.connector.fileFor(id);
        String extension = this.extension();
        if (this.connector.isContentNode(id)) {
            extension = this.resourceExtension();
        }
        return new File(actualFile.getAbsolutePath() + extension);
    }

    public boolean contains(String id) {
        File file = this.sidecarFile(id);
        return file.exists();
    }
}

