/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.connector.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.fcrepo.connector.file.FedoraFileSystemConnector;
import org.fcrepo.kernel.exception.RepositoryRuntimeException;
import org.infinispan.schematic.Schematic;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.EditableDocument;
import org.infinispan.schematic.document.Json;
import org.modeshape.jcr.cache.document.DocumentTranslator;
import org.modeshape.jcr.spi.federation.ExtraPropertiesStore;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Property;

public class ExternalJsonSidecarExtraPropertyStore
implements ExtraPropertiesStore {
    private FedoraFileSystemConnector connector;
    private File propertyStoreRoot;
    private final DocumentTranslator translator;

    public ExternalJsonSidecarExtraPropertyStore(FedoraFileSystemConnector connector, DocumentTranslator translator, File propertyStoreRoot) {
        this.connector = connector;
        this.translator = translator;
        this.propertyStoreRoot = propertyStoreRoot;
    }

    protected File sidecarFile(String id) {
        File file;
        if (this.connector.isRoot(id)) {
            file = new File(this.propertyStoreRoot, "federation-root.modeshape.json");
        } else {
            String ext = ".modeshape.json";
            if (this.connector.isContentNode(id)) {
                ext = ".content.modeshape.json";
            }
            File f = new File(this.connector.fileFor(id).getAbsolutePath() + ext);
            Path propertyFileInFederation = f.getAbsoluteFile().toPath();
            Path relativePath = this.connector.fileFor("/").getAbsoluteFile().toPath().relativize(propertyFileInFederation);
            file = this.propertyStoreRoot.toPath().resolve(relativePath).toFile();
        }
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new RepositoryRuntimeException("Unable to create directories " + file.getParentFile() + ".");
        }
        return file;
    }

    public boolean removeProperties(String id) {
        File file = this.sidecarFile(id);
        if (!file.exists()) {
            return false;
        }
        file.delete();
        return true;
    }

    public Map<Name, Property> getProperties(String id) {
        File sidecarFile = this.sidecarFile(id);
        if (!sidecarFile.exists()) {
            return Collections.emptyMap();
        }
        try {
            Document document = Json.read((InputStream)new FileInputStream(sidecarFile), (boolean)false);
            HashMap<Name, Property> results = new HashMap<Name, Property>();
            this.translator.getProperties(document, results);
            return results;
        }
        catch (IOException e) {
            throw new RepositoryRuntimeException(id, (Throwable)e);
        }
    }

    public void updateProperties(String id, Map<Name, Property> properties) {
        File sidecarFile = this.sidecarFile(id);
        try {
            EditableDocument document = null;
            if (!sidecarFile.exists()) {
                if (properties.isEmpty()) {
                    return;
                }
                sidecarFile.createNewFile();
                document = Schematic.newDocument();
            } else {
                Document existing = Json.read((InputStream)new FileInputStream(sidecarFile), (boolean)false);
                document = Schematic.newDocument((Document)existing);
            }
            for (Map.Entry<Name, Property> entry : properties.entrySet()) {
                Property property = entry.getValue();
                if (property == null) {
                    this.translator.removeProperty(document, entry.getKey(), null, null);
                    continue;
                }
                this.translator.setProperty(document, property, null, null);
            }
            Json.write((Document)document, (OutputStream)new FileOutputStream(sidecarFile));
        }
        catch (IOException e) {
            throw new RepositoryRuntimeException(id, (Throwable)e);
        }
    }

    public void storeProperties(String id, Map<Name, Property> properties) {
        File sidecarFile = this.sidecarFile(id);
        try {
            if (!sidecarFile.exists()) {
                if (properties.isEmpty()) {
                    return;
                }
                sidecarFile.createNewFile();
            }
            EditableDocument document = Schematic.newDocument();
            for (Property property : properties.values()) {
                if (property == null) continue;
                this.translator.setProperty(document, property, null, null);
            }
            Json.write((Document)document, (OutputStream)new FileOutputStream(sidecarFile));
        }
        catch (IOException e) {
            throw new RepositoryRuntimeException(id, (Throwable)e);
        }
    }

    public boolean contains(String id) {
        return this.sidecarFile(id).exists();
    }
}

