/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.connector.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.fcrepo.connector.file.FedoraFileSystemConnector;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.modeshape.jcr.cache.document.DocumentTranslator;
import org.modeshape.jcr.spi.federation.ExtraPropertiesStore;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Property;
import org.modeshape.schematic.Schematic;
import org.modeshape.schematic.document.Document;
import org.modeshape.schematic.document.EditableDocument;
import org.modeshape.schematic.document.Json;

public class ExternalJsonSidecarExtraPropertyStore
implements ExtraPropertiesStore {
    private final FedoraFileSystemConnector connector;
    private final File propertyStoreRoot;
    private final DocumentTranslator translator;

    public ExternalJsonSidecarExtraPropertyStore(FedoraFileSystemConnector connector, DocumentTranslator translator, File propertyStoreRoot) {
        this.connector = connector;
        this.translator = translator;
        this.propertyStoreRoot = propertyStoreRoot;
    }

    protected File sidecarFile(String id) {
        File file;
        if (this.connector.isRoot(id)) {
            file = new File(this.propertyStoreRoot, "federation-root.modeshape.json");
        } else {
            String ext = ".modeshape.json";
            if (this.connector.isContentNode(id)) {
                ext = ".content.modeshape.json";
            }
            File f = new File(this.connector.fileFor(id).getAbsolutePath() + ext);
            Path propertyFileInFederation = f.getAbsoluteFile().toPath();
            Path relativePath = this.connector.fileFor("/").getAbsoluteFile().toPath().relativize(propertyFileInFederation);
            file = this.propertyStoreRoot.toPath().resolve(relativePath).toFile();
        }
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new RepositoryRuntimeException("Unable to create directories " + file.getParentFile() + ".");
        }
        return file;
    }

    public boolean removeProperties(String id) {
        try {
            return Files.deleteIfExists(this.sidecarFile(id).toPath());
        }
        catch (IOException e) {
            throw new RepositoryRuntimeException(id, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<Name, Property> getProperties(String id) {
        File sidecarFile = this.sidecarFile(id);
        if (!sidecarFile.exists()) {
            return Collections.emptyMap();
        }
        try (FileInputStream sidecarStream = new FileInputStream(sidecarFile);){
            Document document = Json.read((InputStream)sidecarStream, (boolean)false);
            HashMap<Name, Property> results = new HashMap<Name, Property>();
            this.translator.getProperties(document, results);
            HashMap<Name, Property> hashMap = results;
            return hashMap;
        }
        catch (IOException e) {
            throw new RepositoryRuntimeException(id, (Throwable)e);
        }
    }

    public void updateProperties(String id, Map<Name, Property> properties) {
        File sidecarFile = this.sidecarFile(id);
        try {
            Throwable throwable;
            EditableDocument document;
            if (!sidecarFile.exists()) {
                if (properties.isEmpty()) {
                    return;
                }
                sidecarFile.createNewFile();
                document = Schematic.newDocument();
            } else {
                throwable = null;
                try (FileInputStream sidecarStream = new FileInputStream(sidecarFile);){
                    Document existing = Json.read((InputStream)sidecarStream, (boolean)false);
                    document = Schematic.newDocument((Document)existing);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            properties.forEach((key, property) -> {
                if (property == null) {
                    this.translator.removeProperty(document, key, null, null);
                } else {
                    this.translator.setProperty(document, property, null, null);
                }
            });
            throwable = null;
            try (FileOutputStream outputStream = new FileOutputStream(sidecarFile);){
                Json.write((Document)document, (OutputStream)outputStream);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException e) {
            throw new RepositoryRuntimeException(id, (Throwable)e);
        }
    }

    public void storeProperties(String id, Map<Name, Property> properties) {
        File sidecarFile = this.sidecarFile(id);
        try {
            if (!sidecarFile.exists()) {
                if (properties.isEmpty()) {
                    return;
                }
                sidecarFile.createNewFile();
            }
            EditableDocument document = Schematic.newDocument();
            for (Property property : properties.values()) {
                if (property == null) continue;
                this.translator.setProperty(document, property, null, null);
            }
            try (FileOutputStream outputStream = new FileOutputStream(sidecarFile);){
                Json.write((Document)document, (OutputStream)outputStream);
            }
        }
        catch (IOException e) {
            throw new RepositoryRuntimeException(id, (Throwable)e);
        }
    }

    public boolean contains(String id) {
        return this.sidecarFile(id).exists();
    }
}

