/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.event.serialization;

import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.DCTerms;
import org.apache.jena.vocabulary.RDF;
import org.fcrepo.kernel.api.observer.FedoraEvent;

public interface EventSerializer {
    public static Model toModel(FedoraEvent evt) {
        String FOAF = "http://xmlns.com/foaf/0.1/";
        Model model = ModelFactory.createDefaultModel();
        String baseUrl = (String)evt.getInfo().get("baseUrl");
        String userAgent = (String)evt.getInfo().get("userAgent");
        Resource root = model.createResource((baseUrl != null ? baseUrl : "info:fedora") + evt.getPath());
        evt.getResourceTypes().forEach(rdfType -> root.addProperty(RDF.type, (RDFNode)ResourceFactory.createResource((String)rdfType)));
        if (baseUrl != null) {
            root.addProperty(DCTerms.isPartOf, (RDFNode)ResourceFactory.createResource((String)baseUrl));
        }
        Resource activity = model.createResource().addProperty(RDF.type, (RDFNode)ResourceFactory.createResource((String)"http://www.w3.org/ns/prov#Activity")).addProperty(DCTerms.identifier, (RDFNode)ResourceFactory.createResource((String)evt.getEventID())).addLiteral(ResourceFactory.createProperty((String)"http://www.w3.org/ns/prov#", (String)"atTime"), ResourceFactory.createTypedLiteral((String)evt.getDate().toString(), (RDFDatatype)XSDDatatype.XSDdateTime));
        evt.getTypes().stream().map(rdfType -> rdfType.getType()).forEach(rdfType -> activity.addProperty(RDF.type, (RDFNode)ResourceFactory.createResource((String)rdfType)));
        root.addProperty(ResourceFactory.createProperty((String)"http://www.w3.org/ns/prov#", (String)"wasGeneratedBy"), (RDFNode)activity);
        root.addProperty(ResourceFactory.createProperty((String)"http://www.w3.org/ns/prov#", (String)"wasAttributedTo"), (RDFNode)model.createResource().addProperty(RDF.type, (RDFNode)ResourceFactory.createResource((String)"http://www.w3.org/ns/prov#Person")).addLiteral(ResourceFactory.createProperty((String)"http://xmlns.com/foaf/0.1/", (String)"name"), (Object)evt.getUserID()));
        if (userAgent != null) {
            root.addProperty(ResourceFactory.createProperty((String)"http://www.w3.org/ns/prov#", (String)"wasAttributedTo"), (RDFNode)model.createResource().addProperty(RDF.type, (RDFNode)ResourceFactory.createResource((String)"http://www.w3.org/ns/prov#SoftwareAgent")).addLiteral(ResourceFactory.createProperty((String)"http://xmlns.com/foaf/0.1/", (String)"name"), (Object)userAgent));
        }
        return model;
    }

    public String serialize(FedoraEvent var1);
}

