/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.event.serialization;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import org.fcrepo.event.serialization.EventSerializer;
import org.fcrepo.event.serialization.JsonLDEventMessage;
import org.fcrepo.kernel.api.observer.FedoraEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonLDSerializer
implements EventSerializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonLDSerializer.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public JsonLDSerializer() {
        MAPPER.registerModule((Module)new JavaTimeModule());
        MAPPER.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
    }

    @Override
    public String serialize(FedoraEvent evt) {
        try {
            return MAPPER.writeValueAsString((Object)JsonLDEventMessage.from(evt));
        }
        catch (JsonProcessingException ex) {
            LOGGER.error("Error processing JSON: {}", (Object)ex.getMessage());
            return null;
        }
    }
}

