/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.event.serialization;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.fcrepo.kernel.api.observer.FedoraEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JsonLDEventMessage {
    @JsonIgnore
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonLDEventMessage.class);
    @JsonProperty(value="id")
    public String id;
    @JsonProperty(value="type")
    public List<String> type;
    @JsonProperty(value="isPartOf")
    public String isPartOf;
    @JsonProperty(value="wasGeneratedBy")
    public Activity wasGeneratedBy;
    @JsonProperty(value="wasAttributedTo")
    public List<Agent> wasAttributedTo;
    @JsonProperty(value="@context")
    public Context context = new Context();

    JsonLDEventMessage() {
    }

    public static JsonLDEventMessage from(FedoraEvent evt) {
        JsonLDEventMessage msg = new JsonLDEventMessage();
        String baseUrl = (String)evt.getInfo().get("baseUrl");
        String userAgent = (String)evt.getInfo().get("userAgent");
        ArrayList<Agent> agents = new ArrayList<Agent>();
        agents.add(new Agent("http://www.w3.org/ns/prov#Person", evt.getUserID()));
        if (userAgent != null) {
            agents.add(new Agent("http://www.w3.org/ns/prov#SoftwareAgent", userAgent));
        }
        msg.wasAttributedTo = agents;
        List<String> types = evt.getTypes().stream().map(rdfType -> rdfType.getType()).collect(Collectors.toList());
        if (!types.contains("http://www.w3.org/ns/prov#Activity")) {
            types.add("http://www.w3.org/ns/prov#Activity");
        }
        msg.wasGeneratedBy = new Activity(evt.getEventID(), evt.getDate(), types);
        if (baseUrl == null) {
            msg.id = "info:fedora" + evt.getPath();
        } else {
            msg.isPartOf = baseUrl;
            msg.id = baseUrl + evt.getPath();
        }
        ArrayList<String> resourceTypes = new ArrayList<String>(evt.getResourceTypes());
        if (!resourceTypes.contains("http://www.w3.org/ns/prov#Entity")) {
            resourceTypes.add("http://www.w3.org/ns/prov#Entity");
        }
        msg.type = resourceTypes;
        return msg;
    }

    static class Agent {
        @JsonProperty(value="type")
        public String type;
        @JsonProperty(value="name")
        public String name;

        public Agent(String type, String name) {
            this.type = type;
            this.name = name;
        }
    }

    static class Activity {
        @JsonProperty(value="type")
        public List<String> type;
        @JsonProperty(value="identifier")
        public String identifier;
        @JsonProperty(value="atTime")
        public Instant atTime;

        public Activity(String identifier, Instant atTime, List<String> type) {
            this.type = type;
            this.identifier = identifier;
            this.atTime = atTime;
        }
    }

    static class Context {
        public final String prov = "http://www.w3.org/ns/prov#";
        public final String foaf = "http://xmlns.com/foaf/0.1/";
        public final String dcterms = "http://purl.org/dc/terms/";
        public final String xsd = "http://www.w3.org/2001/XMLSchema#";
        public final String type = "@type";
        public final String id = "@id";
        public final ContextElement name = new ContextElement("foaf:name", "xsd:string");
        public final ContextElement identifier = new ContextElement("dcterms:identifier");
        public final ContextElement isPartOf = new ContextElement("dcterms:isPartOf");
        public final ContextElement atTime = new ContextElement("prov:atTime", "xsd:dateTime");
        public final ContextElement wasAttributedTo = new ContextElement("prov:wasAttributedTo");
        public final ContextElement wasGeneratedBy = new ContextElement("prov:wasGeneratedBy");

        Context() {
        }
    }

    static class ContextElement {
        @JsonProperty(value="@id")
        public final String id;
        @JsonProperty(value="@type")
        public final String type;

        public ContextElement(String id) {
            this.id = id;
            this.type = "@id";
        }

        public ContextElement(String id, String type) {
            this.id = id;
            this.type = type;
        }
    }
}

