/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.event.serialization;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.fcrepo.http.commons.api.rdf.HttpResourceConverter;
import org.fcrepo.kernel.api.observer.FedoraEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JsonLDEventMessage {
    @JsonIgnore
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonLDEventMessage.class);
    private static final String ACTIVITYSTREAMS_NS = "https://www.w3.org/ns/activitystreams";
    @JsonProperty(value="id")
    public String id;
    @JsonProperty(value="type")
    public List<String> type;
    @JsonProperty(value="name")
    public String name;
    @JsonProperty(value="published")
    public Instant published;
    @JsonProperty(value="actor")
    public List<Actor> actor;
    @JsonProperty(value="object")
    public Object object;
    @JsonProperty(value="@context")
    public List<java.lang.Object> context;

    JsonLDEventMessage() {
    }

    public static JsonLDEventMessage from(FedoraEvent evt) {
        String baseUrl = (String)evt.getInfo().get("baseUrl");
        String objectId = HttpResourceConverter.convertToExternalPath((String)(baseUrl + evt.getPath()));
        List types = evt.getTypes().stream().map(rdfType -> rdfType.getTypeAbbreviated()).collect(Collectors.toList());
        String name = String.join((CharSequence)", ", evt.getTypes().stream().map(rdfType -> rdfType.getName()).collect(Collectors.toList()));
        ArrayList<String> resourceTypes = new ArrayList<String>(evt.getResourceTypes());
        if (!resourceTypes.contains("http://www.w3.org/ns/prov#Entity")) {
            resourceTypes.add("http://www.w3.org/ns/prov#Entity");
        }
        ArrayList<Actor> actor = new ArrayList<Actor>();
        actor.add(new Person(evt.getUserURI().toString(), Collections.singletonList("Person")));
        String softwareAgent = (String)evt.getInfo().get("userAgent");
        if (softwareAgent != null) {
            actor.add(new Application(softwareAgent, Collections.singletonList("Application")));
        }
        JsonLDEventMessage msg = new JsonLDEventMessage();
        msg.id = evt.getEventID();
        msg.context = Arrays.asList(ACTIVITYSTREAMS_NS, new Context());
        msg.actor = actor;
        msg.published = evt.getDate();
        msg.type = types;
        msg.name = name;
        msg.object = new Object(objectId, resourceTypes, baseUrl);
        return msg;
    }

    static class Person
    extends Actor {
        @JsonProperty(value="id")
        public String id;

        public Person(String id, List<String> type) {
            super(type);
            this.id = id;
        }
    }

    static class Application
    extends Actor {
        @JsonProperty(value="name")
        public String name;

        public Application(String name, List<String> type) {
            super(type);
            this.name = name;
        }
    }

    static class Actor {
        @JsonProperty(value="type")
        public List<String> type;

        public Actor(List<String> type) {
            this.type = type;
        }
    }

    static class Object {
        @JsonProperty(value="type")
        public List<String> type;
        @JsonProperty(value="id")
        public String id;
        @JsonProperty(value="isPartOf")
        public String isPartOf;

        public Object(String id, List<String> type, String isPartOf) {
            this.type = type;
            this.id = id;
            this.isPartOf = isPartOf;
        }
    }

    static class Context {
        public final String prov = "http://www.w3.org/ns/prov#";
        public final String dcterms = "http://purl.org/dc/terms/";
        public final String type = "@type";
        public final String id = "@id";
        public final ContextElement isPartOf = new ContextElement("dcterms:isPartOf");

        Context() {
        }
    }

    static class ContextElement {
        @JsonProperty(value="@id")
        public final String id;
        @JsonProperty(value="@type")
        public final String type;

        public ContextElement(String id) {
            this.id = id;
            this.type = "@id";
        }

        public ContextElement(String id, String type) {
            this.id = id;
            this.type = type;
        }
    }
}

