/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.event.serialization;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.fcrepo.kernel.api.observer.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonLDEventMessage {
    @JsonIgnore
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonLDEventMessage.class);
    @JsonProperty(value="id")
    public String id;
    @JsonProperty(value="type")
    public List<String> type;
    @JsonProperty(value="name")
    public String name;
    @JsonProperty(value="published")
    public Instant published;
    @JsonProperty(value="actor")
    public List<Actor> actor;
    @JsonProperty(value="object")
    public Object object;
    @JsonProperty(value="@context")
    public List<java.lang.Object> context;

    public void setPublished(String published) {
        this.published = Instant.from(DateTimeFormatter.ISO_INSTANT.parse(published));
    }

    public static JsonLDEventMessage from(Event evt) {
        String baseUrl = evt.getBaseUrl();
        String objectId = baseUrl + evt.getPath();
        List types = evt.getTypes().stream().map(rdfType -> rdfType.getTypeAbbreviated()).collect(Collectors.toList());
        String name = String.join((CharSequence)", ", evt.getTypes().stream().map(rdfType -> rdfType.getName()).collect(Collectors.toList()));
        ArrayList<String> resourceTypes = new ArrayList<String>(evt.getResourceTypes());
        if (!resourceTypes.contains("http://www.w3.org/ns/prov#Entity")) {
            resourceTypes.add("http://www.w3.org/ns/prov#Entity");
        }
        ArrayList<Actor> actor = new ArrayList<Actor>();
        actor.add(new Person(Objects.toString(evt.getUserURI()), "Person"));
        String softwareAgent = evt.getUserAgent();
        if (softwareAgent != null) {
            actor.add(new Application(softwareAgent, "Application"));
        }
        JsonLDEventMessage msg = new JsonLDEventMessage();
        msg.id = evt.getEventID();
        msg.context = Arrays.asList("https://www.w3.org/ns/activitystreams#", new Context());
        msg.actor = actor;
        msg.published = evt.getDate();
        msg.type = types;
        msg.name = name;
        msg.object = new Object(objectId, resourceTypes, baseUrl);
        return msg;
    }

    public static class Person
    extends Actor {
        @JsonProperty(value="id")
        public String id;

        public Person() {
            super("Person");
        }

        public Person(String id, String type) {
            super(type);
            this.id = id;
        }
    }

    public static class Application
    extends Actor {
        @JsonProperty(value="name")
        public String name;

        public Application() {
            super("Application");
        }

        public Application(String name, String type) {
            super(type);
            this.name = name;
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=Application.class, name="Application"), @JsonSubTypes.Type(value=Person.class, name="Person")})
    public static class Actor {
        @JsonIgnore
        public String type;

        public Actor(String type) {
            this.type = type;
        }
    }

    public static class Object {
        @JsonProperty(value="type")
        public List<String> type;
        @JsonProperty(value="id")
        public String id;
        @JsonProperty(value="isPartOf")
        public String isPartOf;

        public Object() {
        }

        public Object(String id, List<String> type, String isPartOf) {
            this.type = type;
            this.id = id;
            this.isPartOf = isPartOf;
        }
    }

    public static class Context {
        public final String prov = "http://www.w3.org/ns/prov#";
        public final String dcterms = "http://purl.org/dc/terms/";
        public final String type = "@type";
        public final String id = "@id";
        public final ContextElement isPartOf = new ContextElement("dcterms:isPartOf");
    }

    public static class ContextElement {
        @JsonProperty(value="@id")
        public final String id;
        @JsonProperty(value="@type")
        public final String type;

        public ContextElement(String id) {
            this.id = id;
            this.type = "@id";
        }

        public ContextElement(String id, String type) {
            this.id = id;
            this.type = type;
        }
    }
}

