/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.generate;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;

public class BuildAxisStubWrapper {
    private final BufferedWriter m_writer;
    private static String N = System.getProperty("line.separator");

    public BuildAxisStubWrapper(File stubFile, File templateFile, String wrapperPackage, String wrapperClass, File wrapperFile) throws Exception {
        System.out.println("Dynamically generating sourcecode for " + wrapperPackage + "." + wrapperClass);
        StringBuffer importBuf = new StringBuffer();
        StringBuffer tsBuf = new StringBuffer();
        StringBuffer tfBuf = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(templateFile)));
        boolean sawSplitter = false;
        String line = "first";
        boolean sawImports = false;
        while (line != null) {
            if (sawImports && line.equals("##SPLITTER##")) {
                sawSplitter = true;
            } else if (!line.equals("first")) {
                if (!sawImports) {
                    int x = 0;
                    while (!line.equals("##SPLITTER##")) {
                        importBuf.append(line + N);
                        line = reader.readLine();
                        if (++x != 2000) continue;
                        throw new IOException("Template file must contain two ##SPLITTER## lines.");
                    }
                    sawImports = true;
                } else if (sawSplitter) {
                    tfBuf.append("        " + line + N);
                } else {
                    tsBuf.append("        " + line + N);
                }
            }
            line = reader.readLine();
        }
        reader.close();
        String methodStart = tsBuf.toString();
        String methodFinish = tfBuf.toString();
        if (!sawSplitter) {
            throw new IOException("Bad template... does not contain ##SPLITTER## line.");
        }
        this.m_writer = new BufferedWriter(new FileWriter(wrapperFile));
        this.println("package " + wrapperPackage + ";" + N + N + "import java.util.HashMap; // needed by generated code" + N);
        this.println(importBuf.toString());
        this.println("public class " + wrapperClass);
        reader = new BufferedReader(new InputStreamReader(new FileInputStream(stubFile)));
        line = "";
        while (line != null) {
            int i = line.indexOf("implements");
            if (i != -1) {
                String endPart = line.substring(i + 11);
                String interfaceClassName = endPart.substring(0, endPart.indexOf(" "));
                this.println("        implements " + interfaceClassName + " {");
                this.println("");
                this.println("    /** The wrapped instance */");
                this.println("    private " + interfaceClassName + " m_instance;");
                this.println("");
                this.println("    public " + wrapperClass + "(" + interfaceClassName + " instance) {");
                this.println("        m_instance=instance;");
                this.println("    }");
            } else if (line.indexOf("public") != -1 && line.indexOf("throws java.rmi.RemoteException") != -1) {
                String thisMethodFinish;
                String thisMethodStart;
                this.println("");
                this.println(line);
                i = line.indexOf("(");
                String beforeParams = line.substring(0, i);
                int j = beforeParams.lastIndexOf(" ");
                String methodName = beforeParams.substring(j + 1);
                this.println("        String METHOD_NAME=\"" + methodName + "\";");
                this.println("        HashMap PARMS=new HashMap();");
                if (line.indexOf("public boolean ") != -1) {
                    thisMethodStart = methodStart.replaceAll("##RETURN_TYPE##", "Object");
                    thisMethodFinish = methodFinish.replaceAll("##RETURN_TYPE##", "Object");
                    thisMethodStart = thisMethodStart.replaceAll("##RETURN##", "return (Boolean)worker.get();// ");
                    thisMethodFinish = thisMethodFinish.replaceAll("##RETURN##", "return (Boolean)worker.get();// ");
                } else if (line.indexOf(" void ") == -1) {
                    String afterPublic = line.substring(line.indexOf("public") + 7);
                    String returnType = afterPublic.substring(0, afterPublic.indexOf(" "));
                    thisMethodStart = methodStart.replaceAll("##RETURN_TYPE##", returnType);
                    thisMethodFinish = methodFinish.replaceAll("##RETURN_TYPE##", returnType);
                    thisMethodStart = thisMethodStart.replaceAll("##RETURN##", "return ");
                    thisMethodFinish = thisMethodFinish.replaceAll("##RETURN##", "return ");
                } else {
                    thisMethodStart = methodStart.replaceAll("##RETURN_TYPE##", "Object");
                    thisMethodFinish = methodFinish.replaceAll("##RETURN_TYPE##", "Object");
                    thisMethodStart = thisMethodStart.replaceAll("##RETURN##", "// ");
                    thisMethodFinish = thisMethodFinish.replaceAll("##RETURN##", "// ");
                }
                StringBuffer callBuf = new StringBuffer();
                if (line.indexOf(" void ") == -1) {
                    callBuf.append("return ");
                }
                callBuf.append("m_instance." + methodName + "(");
                String parmsAndEnd = line.substring(i + 1);
                String justParms = parmsAndEnd.substring(0, parmsAndEnd.indexOf(")"));
                String[] sigs = justParms.split(" ");
                if (sigs.length > 1) {
                    if (sigs.length == 2) {
                        this.doParm(sigs[0], sigs[1], callBuf);
                    } else {
                        for (int z = 0; z < sigs.length; ++z) {
                            if (sigs[z].indexOf(",") != -1) {
                                this.doParm(sigs[z - 1], sigs[z].substring(0, sigs[z].length() - 1), callBuf);
                                callBuf.append(", ");
                                continue;
                            }
                            if (z != sigs.length - 1) continue;
                            this.doParm(sigs[z - 1], sigs[z], callBuf);
                        }
                    }
                }
                callBuf.append(");");
                this.println(thisMethodStart);
                this.println("// call wrapped method" + N + callBuf.toString() + N);
                this.println(thisMethodFinish + "    }");
            }
            line = reader.readLine();
        }
        reader.close();
        this.println("}");
        this.m_writer.close();
    }

    private void doParm(String t, String n, StringBuffer buf) throws Exception {
        if (t.equals("boolean")) {
            this.println("        PARMS.put(\"" + n + "\", new Boolean(" + n + "));");
            buf.append("((Boolean) parms.get(\"" + n + "\")).booleanValue()");
        } else if (t.equals("int")) {
            this.println("        PARMS.put(\"" + n + "\", new Integer(" + n + "));");
            buf.append("((Integer) parms.get(\"" + n + "\")).intValue()");
        } else {
            this.println("        PARMS.put(\"" + n + "\", " + n + ");");
            buf.append("(" + t + ") parms.get(\"" + n + "\")");
        }
    }

    private void println(String line) throws Exception {
        this.m_writer.write(line, 0, line.length());
        this.m_writer.newLine();
    }

    public static void main(String[] args) {
        int argCount = 5;
        try {
            if (args.length != argCount) {
                throw new IOException("Must supply " + argCount + " arguments.");
            }
            File stub = new File(args[0]);
            File template = new File(args[1]);
            String pkg = args[2];
            String cls = args[3];
            File wrapper = new File(args[4]);
            wrapper.getParentFile().mkdirs();
            new BuildAxisStubWrapper(stub, template, pkg, cls, wrapper);
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                System.err.println(e.getMessage());
            } else {
                e.printStackTrace();
            }
            System.err.println("Usage: BuildAxisStubWrapper stubFile templateFile wrapperPackage wrapperClass wrapperFile");
        }
    }
}

