/**
 * Copyright 2013 DuraSpace, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.fcrepo.exceptionhandlers;

import static com.google.common.base.Throwables.getStackTraceAsString;
import static javax.ws.rs.core.Response.serverError;
import static org.slf4j.LoggerFactory.getLogger;

import javax.jcr.RepositoryException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

import org.slf4j.Logger;

/**
 * Provide a quasi-useful stacktrace when a generic RepositoryException is caught
 */
@Provider
public class RepositoryExceptionMapper implements
        ExceptionMapper<RepositoryException> {

    private final Logger LOGGER = getLogger(RepositoryExceptionMapper.class);

    Boolean showStackTrace = true;

    @Override
    public Response toResponse(RepositoryException e) {

        LOGGER.warn("Caught repository exception: {}", e);

        return serverError().entity(
                showStackTrace ? getStackTraceAsString(e) : null).build();
    }
}
