/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo;

import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriInfo;
import org.fcrepo.AbstractResource;
import org.fcrepo.identifiers.PidMinter;
import org.fcrepo.services.NodeService;
import org.fcrepo.test.util.PathSegmentImpl;
import org.fcrepo.test.util.TestHelpers;
import org.fcrepo.utils.NamespaceTools;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.modeshape.jcr.api.NamespaceRegistry;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"org.slf4j.*", "javax.xml.parsers.*", "org.apache.xerces.*"})
@PrepareForTest(value={NamespaceTools.class})
public class AbstractResourceTest {
    AbstractResource testObj;

    @Before
    public void setUp() {
        this.testObj = new AbstractResource(){};
    }

    @Test
    public void testInitialize() throws RepositoryException {
        NamespaceRegistry namespaceRegistry = (NamespaceRegistry)Mockito.mock(NamespaceRegistry.class);
        PowerMockito.mockStatic(NamespaceTools.class, (Class[])new Class[0]);
        Mockito.when((Object)NamespaceTools.getNamespaceRegistry((Session)((Session)Matchers.any(Session.class)))).thenReturn((Object)namespaceRegistry);
        this.testObj.initialize();
    }

    @Test
    public void testSetPidMinter() throws Exception {
        PidMinter pidMinter = (PidMinter)Mockito.mock(PidMinter.class);
        TestHelpers.setField(this.testObj, "pidMinter", pidMinter);
        Assert.assertEquals((Object)pidMinter, (Object)this.testObj.pidMinter);
    }

    @Test
    public void testSetNodeService() throws Exception {
        NodeService nodeService = (NodeService)Mockito.mock(NodeService.class);
        TestHelpers.setField(this.testObj, "nodeService", nodeService);
        Assert.assertEquals((Object)nodeService, (Object)this.testObj.nodeService);
    }

    @Test
    public void testSetUriInfo() throws Exception {
        UriInfo uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
        TestHelpers.setField(this.testObj, "uriInfo", uriInfo);
        Assert.assertEquals((Object)uriInfo, (Object)this.testObj.uriInfo);
    }

    @Test
    public void testToPath() {
        List<PathSegment> list = PathSegmentImpl.createPathList("foo", "", "bar", "baz");
        String string = "/foo/bar/baz";
        String string2 = AbstractResource.toPath(list);
        Assert.assertEquals((Object)string, (Object)string2);
    }

    @Test
    public void testToPathWorkspace() {
        List<PathSegment> list = PathSegmentImpl.createPathList("workspace:abc", "bar", "baz");
        String string = "/bar/baz";
        String string2 = AbstractResource.toPath(list);
        Assert.assertEquals((Object)string, (Object)string2);
    }

    @Test
    public void testToPathWorkspaceInSomeOtherSegment() {
        List<PathSegment> list = PathSegmentImpl.createPathList("asdf", "workspace:abc", "bar", "baz");
        String string = "/asdf/workspace:abc/bar/baz";
        String string2 = AbstractResource.toPath(list);
        Assert.assertEquals((Object)string, (Object)string2);
    }

    @Test
    public void testToPathWorkspaceWithEmptyPrefix() {
        List<PathSegment> list = PathSegmentImpl.createPathList("", "workspace:abc", "bar", "baz");
        String string = "/bar/baz";
        String string2 = AbstractResource.toPath(list);
        Assert.assertEquals((Object)string, (Object)string2);
    }

    @Test
    public void testToPathTransaction() {
        List<PathSegment> list = PathSegmentImpl.createPathList("tx:abc", "bar", "baz");
        String string = "/bar/baz";
        String string2 = AbstractResource.toPath(list);
        Assert.assertEquals((Object)string, (Object)string2);
    }

    @Test
    public void testToPathTxInSomeOtherSegment() {
        List<PathSegment> list = PathSegmentImpl.createPathList("asdf", "tx:abc", "bar", "baz");
        String string = "/asdf/tx:abc/bar/baz";
        String string2 = AbstractResource.toPath(list);
        Assert.assertEquals((Object)string, (Object)string2);
    }

    @Test
    public void testToPathTxWithEmptyPrefix() {
        List<PathSegment> list = PathSegmentImpl.createPathList("", "tx:abc", "bar", "baz");
        String string = "/bar/baz";
        String string2 = AbstractResource.toPath(list);
        Assert.assertEquals((Object)string, (Object)string2);
    }

    @Test
    public void testToPathUuid() {
        List<PathSegment> list = PathSegmentImpl.createPathList("[foo]");
        String string = "[foo]";
        String string2 = AbstractResource.toPath(list);
        Assert.assertEquals((Object)string, (Object)string2);
    }

    @Test
    public void testToPathEmpty() {
        List<PathSegment> list = PathSegmentImpl.createPathList(new String[0]);
        String string = "/";
        String string2 = AbstractResource.toPath(list);
        Assert.assertEquals((Object)string, (Object)string2);
    }
}

