/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.api.rdf;

import com.hp.hpl.jena.rdf.model.Resource;
import com.sun.jersey.api.uri.UriBuilderImpl;
import java.net.URI;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.ws.rs.Path;
import javax.ws.rs.core.UriInfo;
import org.fcrepo.api.rdf.HttpGraphSubjects;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class HttpGraphSubjectsTest {
    private HttpGraphSubjects testObj;
    private String testPath = "/foo/bar";
    private Session mockSession;

    @Before
    public void setUp() {
        UriInfo uriInfo = HttpGraphSubjectsTest.getUriInfoImpl(this.testPath);
        this.mockSession = (Session)Mockito.mock(Session.class);
        this.testObj = new HttpGraphSubjects(MockNodeController.class, uriInfo, this.mockSession);
    }

    @Test
    public void testGetGraphSubject() throws RepositoryException {
        String string = "http://localhost:8080/fcrepo/rest" + this.testPath;
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)node.getPath()).thenReturn((Object)this.testPath);
        Workspace workspace = (Workspace)Mockito.mock(Workspace.class);
        Mockito.when((Object)workspace.getName()).thenReturn((Object)"default");
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)workspace);
        Mockito.when((Object)node.getSession()).thenReturn((Object)this.mockSession);
        Resource resource = this.testObj.getGraphSubject(node);
        Assert.assertEquals((Object)string, (Object)resource.getURI());
        Mockito.when((Object)node.getPath()).thenReturn((Object)(this.testPath + "/jcr:content"));
        resource = this.testObj.getGraphSubject(node);
        Assert.assertEquals((Object)(string + "/fcr:content"), (Object)resource.getURI());
    }

    @Test
    public void testGetNodeFromGraphSubject() throws PathNotFoundException, RepositoryException {
        Session session = (Session)Mockito.mock(Session.class);
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)session.nodeExists(this.testPath)).thenReturn((Object)true);
        Mockito.when((Object)session.getNode(this.testPath)).thenReturn((Object)node);
        Workspace workspace = (Workspace)Mockito.mock(Workspace.class);
        Mockito.when((Object)workspace.getName()).thenReturn((Object)"default");
        Mockito.when((Object)session.getWorkspace()).thenReturn((Object)workspace);
        Resource resource = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)resource.getURI()).thenReturn((Object)("http://localhost:8080/fcrepo/rest" + this.testPath));
        Mockito.when((Object)resource.isURIResource()).thenReturn((Object)true);
        Node node2 = this.testObj.getNodeFromGraphSubject(session, resource);
        ((Session)Mockito.verify((Object)session)).getNode(this.testPath);
        Assert.assertEquals((Object)node, (Object)node2);
        Mockito.when((Object)resource.getURI()).thenReturn((Object)("http://localhost:8080/fcrepo/rest2" + this.testPath + "/bad"));
        node2 = this.testObj.getNodeFromGraphSubject(session, resource);
        Assert.assertEquals(null, (Object)node2);
        Mockito.when((Object)resource.getURI()).thenReturn((Object)("http://localhost:8080/fcrepo/rest" + this.testPath + "/bad"));
        node2 = this.testObj.getNodeFromGraphSubject(session, resource);
        Assert.assertEquals(null, (Object)node2);
        Mockito.when((Object)resource.getURI()).thenReturn((Object)("http://localhost:8080/fcrepo/rest" + this.testPath + "/fcr:content"));
        node2 = this.testObj.getNodeFromGraphSubject(session, resource);
        ((Session)Mockito.verify((Object)session)).getNode(this.testPath + "/jcr:content");
    }

    @Test
    public void testIsFedoraGraphSubject() {
        Resource resource = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)resource.getURI()).thenReturn((Object)"http://localhost:8080/fcrepo/rest/foo");
        Mockito.when((Object)resource.isURIResource()).thenReturn((Object)true);
        boolean bl = this.testObj.isFedoraGraphSubject(resource);
        Assert.assertEquals((Object)true, (Object)bl);
        Mockito.when((Object)resource.getURI()).thenReturn((Object)"http://fedora/foo");
        bl = this.testObj.isFedoraGraphSubject(resource);
        Assert.assertEquals((Object)false, (Object)bl);
    }

    private static UriInfo getUriInfoImpl(String string) {
        UriInfo uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
        UriBuilderImpl uriBuilderImpl = new UriBuilderImpl();
        uriBuilderImpl.scheme("http");
        uriBuilderImpl.host("localhost");
        uriBuilderImpl.port(8080);
        uriBuilderImpl.path("/fcrepo");
        UriBuilderImpl uriBuilderImpl2 = new UriBuilderImpl();
        uriBuilderImpl2.scheme("http");
        uriBuilderImpl2.host("localhost");
        uriBuilderImpl2.port(8080);
        uriBuilderImpl2.path("/fcrepo/rest" + string);
        Mockito.when((Object)uriInfo.getRequestUri()).thenReturn((Object)URI.create("http://localhost:8080/fcrepo/rest" + string));
        Mockito.when((Object)uriInfo.getBaseUri()).thenReturn((Object)URI.create("http://localhost:8080/fcrepo"));
        Mockito.when((Object)uriInfo.getBaseUriBuilder()).thenReturn((Object)uriBuilderImpl);
        Mockito.when((Object)uriInfo.getAbsolutePathBuilder()).thenReturn((Object)uriBuilderImpl2);
        return uriInfo;
    }

    @Path(value="/rest/{path}")
    private class MockNodeController {
        private MockNodeController() {
        }
    }
}

