/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.api.rdf;

import com.google.common.collect.ImmutableBiMap;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import javax.jcr.RepositoryException;
import javax.ws.rs.core.UriInfo;
import org.fcrepo.FedoraResource;
import org.fcrepo.api.rdf.HttpTripleUtil;
import org.fcrepo.api.rdf.UriAwareResourceModelFactory;
import org.fcrepo.rdf.GraphSubjects;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.springframework.context.ApplicationContext;

public class HttpTripleUtilTest {
    private HttpTripleUtil testObj;
    private Dataset dataset;
    private UriInfo mockUriInfo;
    private GraphSubjects mockSubjects;
    private ApplicationContext mockContext;

    @Before
    public void setUp() {
        this.mockContext = (ApplicationContext)Mockito.mock(ApplicationContext.class);
        this.testObj = new HttpTripleUtil();
        this.testObj.setApplicationContext(this.mockContext);
        this.dataset = DatasetFactory.create((Model)ModelFactory.createDefaultModel());
        this.mockUriInfo = (UriInfo)Mockito.mock(UriInfo.class);
        this.mockSubjects = (GraphSubjects)Mockito.mock(GraphSubjects.class);
    }

    @Test
    public void shouldAddTriplesFromRegisteredBeans() throws RepositoryException {
        FedoraResource fedoraResource = (FedoraResource)Mockito.mock(FedoraResource.class);
        UriAwareResourceModelFactory uriAwareResourceModelFactory = (UriAwareResourceModelFactory)Mockito.mock(UriAwareResourceModelFactory.class);
        UriAwareResourceModelFactory uriAwareResourceModelFactory2 = (UriAwareResourceModelFactory)Mockito.mock(UriAwareResourceModelFactory.class);
        ImmutableBiMap immutableBiMap = ImmutableBiMap.of((Object)"doesnt", (Object)uriAwareResourceModelFactory, (Object)"matter", (Object)uriAwareResourceModelFactory2);
        Mockito.when((Object)this.mockContext.getBeansOfType(UriAwareResourceModelFactory.class)).thenReturn((Object)immutableBiMap);
        Mockito.when((Object)uriAwareResourceModelFactory.createModelForResource((FedoraResource)Matchers.eq((Object)fedoraResource), (UriInfo)Matchers.eq((Object)this.mockUriInfo), (GraphSubjects)Matchers.eq((Object)this.mockSubjects))).thenReturn((Object)ModelFactory.createDefaultModel());
        Mockito.when((Object)uriAwareResourceModelFactory2.createModelForResource((FedoraResource)Matchers.eq((Object)fedoraResource), (UriInfo)Matchers.eq((Object)this.mockUriInfo), (GraphSubjects)Matchers.eq((Object)this.mockSubjects))).thenReturn((Object)ModelFactory.createDefaultModel());
        this.testObj.addHttpComponentModelsForResource(this.dataset, fedoraResource, this.mockUriInfo, this.mockSubjects);
        ((UriAwareResourceModelFactory)Mockito.verify((Object)uriAwareResourceModelFactory)).createModelForResource((FedoraResource)Matchers.eq((Object)fedoraResource), (UriInfo)Matchers.eq((Object)this.mockUriInfo), (GraphSubjects)Matchers.eq((Object)this.mockSubjects));
        ((UriAwareResourceModelFactory)Mockito.verify((Object)uriAwareResourceModelFactory2)).createModelForResource((FedoraResource)Matchers.eq((Object)fedoraResource), (UriInfo)Matchers.eq((Object)this.mockUriInfo), (GraphSubjects)Matchers.eq((Object)this.mockSubjects));
    }
}

