/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.responses;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.modify.GraphStoreBasic;
import com.hp.hpl.jena.update.GraphStore;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.jcr.RepositoryException;
import javax.ws.rs.WebApplicationException;
import org.fcrepo.http.RDFMediaType;
import org.fcrepo.responses.GraphStoreStreamingOutput;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphStreamingOutputTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphStreamingOutputTest.class);

    @Test
    public void testStuff() throws WebApplicationException, IOException, RepositoryException {
        GraphStoreBasic graphStoreBasic = new GraphStoreBasic(DatasetFactory.create((Model)ModelFactory.createDefaultModel()));
        GraphMem graphMem = new GraphMem();
        graphMem.add(new Triple(NodeFactory.createURI((String)"test:subject"), NodeFactory.createURI((String)"test:predicate"), NodeFactory.createURI((String)"test:object")));
        graphStoreBasic.setDefaultGraph((Graph)graphMem);
        GraphStoreStreamingOutput graphStoreStreamingOutput = new GraphStoreStreamingOutput((GraphStore)graphStoreBasic, RDFMediaType.NTRIPLES_TYPE);
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            graphStoreStreamingOutput.write((OutputStream)byteArrayOutputStream);
            String string = byteArrayOutputStream.toString();
            LOGGER.debug("Created serialized RDF: \n {}", (Object)string);
            Assert.assertTrue((String)"Couldn't find test subject!", (boolean)string.contains("test:subject"));
            Assert.assertTrue((String)"Couldn't find test predicate!", (boolean)string.contains("test:predicate"));
            Assert.assertTrue((String)"Couldn't find test object!", (boolean)string.contains("test:object"));
        }
    }
}

