/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.responses;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.sparql.core.DatasetImpl;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.Symbol;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.Calendar;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.fcrepo.responses.RdfSerializationUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Test;

public class RdfSerializationUtilsTest {
    Dataset testData = new DatasetImpl(ModelFactory.createDefaultModel());

    public RdfSerializationUtilsTest() {
        this.testData.asDatasetGraph().getDefaultGraph().add(new Triple(NodeFactory.createURI((String)"test:subject"), NodeFactory.createURI((String)"test:predicate"), NodeFactory.createLiteral((String)"test:object")));
    }

    @Test
    public void testGetFirstValueForPredicate() {
        String string = RdfSerializationUtils.getFirstValueForPredicate((Dataset)this.testData, (Node)Node.ANY, (Node)NodeFactory.createURI((String)"test:predicate"));
        Assert.assertEquals((String)"Didn't find correct value for predicate!", (Object)string, (Object)"test:object");
    }

    @Test
    public void testSetCachingHeaders() {
        MultivaluedMapImpl multivaluedMapImpl = new MultivaluedMapImpl();
        RdfSerializationUtils.setCachingHeaders((MultivaluedMap)multivaluedMapImpl, (Dataset)this.testData);
        Assert.assertTrue((((List)multivaluedMapImpl.get((Object)"Cache-Control")).size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSetCachingHeadersWithLastModified() {
        MultivaluedMapImpl multivaluedMapImpl = new MultivaluedMapImpl();
        Model model = ModelFactory.createDefaultModel();
        Calendar calendar = Calendar.getInstance();
        model.add(model.createResource("test:subject"), model.createProperty(RdfSerializationUtils.lastModifiedPredicate.getURI()), (RDFNode)model.createTypedLiteral(calendar));
        Dataset dataset = DatasetFactory.create((Model)model);
        Context context = dataset.getContext();
        context.set(Symbol.create((String)"uri"), (Object)"test:subject");
        RdfSerializationUtils.setCachingHeaders((MultivaluedMap)multivaluedMapImpl, (Dataset)dataset);
        Assert.assertTrue((boolean)new DateTime((Object)calendar).withMillisOfSecond(0).isEqual((ReadableInstant)RdfSerializationUtils.RFC2822DATEFORMAT.parseDateTime((String)((List)multivaluedMapImpl.get((Object)"Last-Modified")).get(0))));
    }
}

