/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.responses;

import com.google.common.collect.ImmutableMap;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.sparql.core.Quad;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriInfo;
import org.fcrepo.RdfLexicon;
import org.fcrepo.responses.ViewHelpers;
import org.fcrepo.test.util.TestHelpers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ViewHelpersTest {
    private ViewHelpers testObj;

    @Before
    public void setUp() {
        this.testObj = ViewHelpers.getInstance();
    }

    @Test
    public void shouldConvertAUriToNodeBreadcrumbs() {
        UriInfo uriInfo = TestHelpers.getUriInfoImpl();
        Map map = this.testObj.getNodeBreadcrumbs(uriInfo, ResourceFactory.createResource((String)"http://localhost/fcrepo/a/b/c").asNode());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"http://localhost/fcrepo/a", (Object)"a", (Object)"http://localhost/fcrepo/a/b", (Object)"b", (Object)"http://localhost/fcrepo/a/b/c", (Object)"c"), (Object)map);
    }

    @Test
    public void shouldRefuseToConvertAForeignUriToNodeBreadcrumbs() {
        UriInfo uriInfo = TestHelpers.getUriInfoImpl();
        Map map = this.testObj.getNodeBreadcrumbs(uriInfo, ResourceFactory.createResource((String)"http://somewhere/else/a/b/c").asNode());
        Assert.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void shouldTryToExtractDublinCoreTitleFromNode() {
        DatasetGraph datasetGraph = DatasetGraphFactory.createMem();
        datasetGraph.add(NodeFactory.createAnon(), NodeFactory.createURI((String)"a/b/c"), RdfLexicon.DC_TITLE.asNode(), NodeFactory.createLiteral((String)"abc"));
        Assert.assertEquals((Object)"abc", (Object)this.testObj.getObjectTitle(datasetGraph, NodeFactory.createURI((String)"a/b/c")));
    }

    @Test
    public void shouldUseTheObjectUriIfATitleIsNotAvailable() {
        DatasetGraph datasetGraph = DatasetGraphFactory.createMem();
        Assert.assertEquals((Object)"a/b/c", (Object)this.testObj.getObjectTitle(datasetGraph, NodeFactory.createURI((String)"a/b/c")));
    }

    @Test
    public void shouldUsetheBNodeIdIfItIsABNode() {
        DatasetGraph datasetGraph = DatasetGraphFactory.createMem();
        Node node = NodeFactory.createAnon();
        Assert.assertEquals((Object)node.getBlankNodeLabel(), (Object)this.testObj.getObjectTitle(datasetGraph, node));
    }

    @Test
    public void shouldJustUseTheStringIfItIsALiteral() {
        DatasetGraph datasetGraph = DatasetGraphFactory.createMem();
        Node node = NodeFactory.createLiteral((String)"xyz");
        Assert.assertEquals((Object)"\"xyz\"", (Object)this.testObj.getObjectTitle(datasetGraph, node));
    }

    @Test
    public void shouldConvertRdfObjectsToStrings() {
        DatasetGraph datasetGraph = DatasetGraphFactory.createMem();
        datasetGraph.add(NodeFactory.createAnon(), NodeFactory.createURI((String)"subject"), NodeFactory.createURI((String)"a/b/c"), NodeFactory.createLiteral((String)"abc"));
        datasetGraph.add(NodeFactory.createAnon(), NodeFactory.createURI((String)"subject"), NodeFactory.createURI((String)"a-numeric-type"), ResourceFactory.createTypedLiteral((Object)0).asNode());
        datasetGraph.add(NodeFactory.createAnon(), NodeFactory.createURI((String)"subject"), NodeFactory.createURI((String)"an-empty-string"), NodeFactory.createLiteral((String)""));
        datasetGraph.add(NodeFactory.createAnon(), NodeFactory.createURI((String)"subject"), NodeFactory.createURI((String)"a-uri"), NodeFactory.createURI((String)"some-uri"));
        Assert.assertEquals((Object)"abc", (Object)this.testObj.getObjectsAsString(datasetGraph, NodeFactory.createURI((String)"subject"), ResourceFactory.createResource((String)"a/b/c")));
        Assert.assertEquals((Object)"0", (Object)this.testObj.getObjectsAsString(datasetGraph, NodeFactory.createURI((String)"subject"), ResourceFactory.createResource((String)"a-numeric-type")));
        Assert.assertEquals((Object)"<empty>", (Object)this.testObj.getObjectsAsString(datasetGraph, NodeFactory.createURI((String)"subject"), ResourceFactory.createResource((String)"an-empty-string")));
        Assert.assertEquals((Object)"&lt;<a href=\"some-uri\">some-uri</a>&gt;", (Object)this.testObj.getObjectsAsString(datasetGraph, NodeFactory.createURI((String)"subject"), ResourceFactory.createResource((String)"a-uri")));
        Assert.assertEquals((Object)"", (Object)this.testObj.getObjectsAsString(datasetGraph, NodeFactory.createURI((String)"subject"), ResourceFactory.createResource((String)"a-nonexistent-uri")));
    }

    @Test
    public void shouldExtractNamespaceAndPrefix() {
        Model model = ModelFactory.createDefaultModel();
        model.setNsPrefix("prefix", "namespace");
        Assert.assertEquals((Object)"prefix:", (Object)this.testObj.getNamespacePrefix((PrefixMapping)model, "namespace"));
        Assert.assertEquals((Object)"some-other-namespace", (Object)this.testObj.getNamespacePrefix((PrefixMapping)model, "some-other-namespace"));
    }

    @Test
    public void shouldSortTriplesForDisplay() {
        Model model = ModelFactory.createDefaultModel();
        model.setNsPrefix("prefix", "namespace");
        Property property = model.createProperty("namespace", "a");
        Property property2 = model.createProperty("namespace", "b");
        Property property3 = model.createProperty("c");
        Literal literal = model.createLiteral("a");
        Literal literal2 = model.createLiteral("b");
        Resource resource = model.createResource("b");
        model.add(resource, property, (RDFNode)literal);
        Resource resource2 = model.createResource("a");
        model.add(resource2, property3, (RDFNode)literal);
        model.add(resource2, property2, (RDFNode)literal);
        model.add(resource2, property, (RDFNode)literal);
        model.add(resource2, property, (RDFNode)literal2);
        Iterator iterator = DatasetFactory.create((Model)model).asDatasetGraph().find();
        List list = this.testObj.getSortedTriples(model, iterator);
        ((Quad)list.get(0)).matches(Node.ANY, resource2.asNode(), property.asNode(), literal.asNode());
        ((Quad)list.get(1)).matches(Node.ANY, resource2.asNode(), property.asNode(), literal2.asNode());
        ((Quad)list.get(2)).matches(Node.ANY, resource2.asNode(), property2.asNode(), literal.asNode());
        ((Quad)list.get(3)).matches(Node.ANY, resource2.asNode(), property3.asNode(), literal.asNode());
        ((Quad)list.get(4)).matches(Node.ANY, resource.asNode(), property3.asNode(), literal.asNode());
    }

    @Test
    public void shouldConvertPrefixMappingToSparqlUpdatePrefixPreamble() {
        Model model = ModelFactory.createDefaultModel();
        model.setNsPrefix("prefix", "namespace");
        String string = this.testObj.getPrefixPreamble((PrefixMapping)model);
        Assert.assertEquals((Object)"PREFIX prefix: <namespace>\n\n", (Object)string);
    }

    @Test
    public void shouldConvertRdfResourcesToNodes() {
        Assert.assertEquals((Object)RdfLexicon.CREATED_BY.asNode(), (Object)this.testObj.asNode((Resource)RdfLexicon.CREATED_BY));
    }
}

