/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.session;

import java.security.Principal;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.SecurityContext;
import org.fcrepo.Transaction;
import org.fcrepo.services.TransactionService;
import org.fcrepo.session.SessionFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class SessionFactoryTest {
    SessionFactory testObj;
    Repository mockRepo;
    TransactionService mockTxService;

    @Before
    public void setUp() {
        this.mockRepo = (Repository)Mockito.mock(Repository.class);
        this.mockTxService = (TransactionService)Mockito.mock(TransactionService.class);
        this.testObj = new SessionFactory(this.mockRepo, this.mockTxService);
        this.testObj.init();
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testGetSessionWithNullPath() throws LoginException, RepositoryException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)httpServletRequest.getPathInfo()).thenReturn(null);
        this.testObj.getSession(httpServletRequest);
        ((Repository)Mockito.verify((Object)this.mockRepo)).login();
    }

    @Test
    public void testGetSessionAuthenticated() throws LoginException, RepositoryException {
        SecurityContext securityContext = (SecurityContext)Mockito.mock(SecurityContext.class);
        Principal principal = (Principal)Mockito.mock(Principal.class);
        Mockito.when((Object)securityContext.getUserPrincipal()).thenReturn((Object)principal);
        HttpServletRequest httpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)httpServletRequest.getPathInfo()).thenReturn((Object)"/some/path");
        this.testObj.getSession(securityContext, httpServletRequest);
        ((Repository)Mockito.verify((Object)this.mockRepo)).login((Credentials)Matchers.any(Credentials.class));
    }

    @Test
    public void testGetSessionUnauthenticated() throws LoginException, RepositoryException {
        this.testObj.getSession();
        ((Repository)Mockito.verify((Object)this.mockRepo)).login();
    }

    @Test
    public void testGetSessionWithWorkspace() throws LoginException, RepositoryException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)httpServletRequest.getPathInfo()).thenReturn((Object)"/workspace:some-workspace/some/path");
        this.testObj.getSession(httpServletRequest);
        ((Repository)Mockito.verify((Object)this.mockRepo)).login("some-workspace");
    }

    @Test
    public void testGetSessionWithTransaction() throws LoginException, RepositoryException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)httpServletRequest.getPathInfo()).thenReturn((Object)"/tx:123/some/path");
        Transaction transaction = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)transaction.getSession()).thenReturn(Mockito.mock(Session.class));
        Mockito.when((Object)this.mockTxService.getTransaction("123")).thenReturn((Object)transaction);
        Session session = this.testObj.getSession(httpServletRequest);
        Assert.assertEquals((Object)transaction.getSession(), (Object)session);
    }

    @Test
    public void testGetAuthenticatedSessionWithWorkspace() throws LoginException, RepositoryException {
        SecurityContext securityContext = (SecurityContext)Mockito.mock(SecurityContext.class);
        Principal principal = (Principal)Mockito.mock(Principal.class);
        Mockito.when((Object)securityContext.getUserPrincipal()).thenReturn((Object)principal);
        HttpServletRequest httpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)httpServletRequest.getPathInfo()).thenReturn((Object)"/workspace:some-workspace/some/path");
        this.testObj.getSession(securityContext, httpServletRequest);
        ((Repository)Mockito.verify((Object)this.mockRepo)).login((Credentials)Matchers.any(Credentials.class), (String)Matchers.eq((Object)"some-workspace"));
    }

    @Test
    public void testGetAuthenticatedSessionWithTransaction() throws LoginException, RepositoryException {
        SecurityContext securityContext = (SecurityContext)Mockito.mock(SecurityContext.class);
        Principal principal = (Principal)Mockito.mock(Principal.class);
        Mockito.when((Object)securityContext.getUserPrincipal()).thenReturn((Object)principal);
        HttpServletRequest httpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)httpServletRequest.getPathInfo()).thenReturn((Object)"/tx:123/some/path");
        Transaction transaction = (Transaction)Mockito.mock(Transaction.class);
        Session session = (Session)Mockito.mock(Session.class);
        Session session2 = (Session)Mockito.mock(Session.class);
        Mockito.when((Object)session.impersonate((Credentials)Matchers.any(Credentials.class))).thenReturn((Object)session2);
        Mockito.when((Object)transaction.getSession()).thenReturn((Object)session);
        Mockito.when((Object)this.mockTxService.getTransaction("123")).thenReturn((Object)transaction);
        Session session3 = this.testObj.getSession(securityContext, httpServletRequest);
        Assert.assertEquals((Object)session2, (Object)session3);
        ((Session)Mockito.verify((Object)session)).impersonate((Credentials)Matchers.any(Credentials.class));
    }

    @Test
    public void testGetSessionProvider() {
        SecurityContext securityContext = (SecurityContext)Mockito.mock(SecurityContext.class);
        Principal principal = (Principal)Mockito.mock(Principal.class);
        Mockito.when((Object)securityContext.getUserPrincipal()).thenReturn((Object)principal);
        HttpServletRequest httpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.testObj.getSessionProvider(securityContext, httpServletRequest);
    }
}

