/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.session;

import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.spi.inject.Injectable;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.SecurityContext;
import org.fcrepo.session.InjectableSession;
import org.fcrepo.session.InjectedSession;
import org.fcrepo.session.SessionFactory;
import org.fcrepo.session.SessionProvider;
import org.fcrepo.test.util.TestHelpers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class SessionProviderTest {
    SessionProvider testObj;
    Repository mockRepo;
    Session mockSession;

    @Before
    public void setUp() throws RepositoryException, NoSuchFieldException {
        this.mockSession = (Session)Mockito.mock(Session.class);
        this.mockRepo = (Repository)Mockito.mock(Repository.class);
        SessionFactory sessionFactory = (SessionFactory)Mockito.mock(SessionFactory.class);
        Mockito.when((Object)sessionFactory.getSession()).thenReturn((Object)this.mockSession);
        SecurityContext securityContext = (SecurityContext)Mockito.mock(SecurityContext.class);
        HttpServletRequest httpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)sessionFactory.getSession(securityContext, httpServletRequest)).thenReturn((Object)this.mockSession);
        this.testObj = new SessionProvider();
        TestHelpers.setField(this.testObj, "sessionFactory", sessionFactory);
        TestHelpers.setField(this.testObj, "secContext", securityContext);
        TestHelpers.setField(this.testObj, "request", httpServletRequest);
    }

    @Test
    public void testGetInjectable() {
        ComponentContext componentContext = (ComponentContext)Mockito.mock(ComponentContext.class);
        InjectedSession injectedSession = (InjectedSession)Mockito.mock(InjectedSession.class);
        Injectable injectable = this.testObj.getInjectable(componentContext, injectedSession);
        Assert.assertNotNull((String)"Didn't get an Injectable<Session>!", (Object)injectable);
        Assert.assertTrue((String)"Didn't get an InjectableSession!", (boolean)InjectableSession.class.isAssignableFrom(injectable.getClass()));
    }
}

