/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.util;

import com.sun.jersey.api.container.grizzly2.GrizzlyServerFactory;
import java.net.URI;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.fcrepo.webxml.WebAppConfig;
import org.fcrepo.webxml.bind.ContextParam;
import org.fcrepo.webxml.bind.Filter;
import org.fcrepo.webxml.bind.FilterMapping;
import org.fcrepo.webxml.bind.InitParam;
import org.fcrepo.webxml.bind.Listener;
import org.fcrepo.webxml.bind.Servlet;
import org.fcrepo.webxml.bind.ServletMapping;
import org.fcrepo.webxml.bind.UrlMappable;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.servlet.ServletRegistration;
import org.glassfish.grizzly.servlet.WebappContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ContainerWrapper
implements ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(ContainerWrapper.class);
    private int port;
    private HttpServer server;
    private WebappContext appContext;
    private String configLocation;

    public void setConfigLocation(String string) {
        this.configLocation = string.replaceFirst("^classpath:", "/");
    }

    public void setPort(int n) {
        this.port = n;
    }

    @PostConstruct
    public void start() throws Exception {
        Collection<UrlMappable> collection;
        ServletRegistration servletRegistration;
        JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{WebAppConfig.class});
        Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
        WebAppConfig webAppConfig = (WebAppConfig)unmarshaller.unmarshal(this.getClass().getResource(this.configLocation));
        URI uRI = URI.create("http://localhost:" + this.port);
        this.server = GrizzlyServerFactory.createHttpServer((URI)uRI, (HttpHandler)new HttpHandler(){

            public void service(Request request, Response response) throws Exception {
                response.setStatus(404, "Not found");
                response.getWriter().write("404: not found");
            }
        });
        this.appContext = new WebappContext(webAppConfig.displayName(), "/");
        for (ContextParam describable : webAppConfig.contextParams()) {
            this.appContext.addContextInitParameter(describable.name(), describable.value());
        }
        for (Listener listener : webAppConfig.listeners()) {
            this.appContext.addListener(listener.className());
        }
        for (Servlet servlet : webAppConfig.servlets()) {
            servletRegistration = this.appContext.addServlet(servlet.servletName(), servlet.servletClass());
            collection = webAppConfig.servletMappings(servlet.servletName());
            for (ServletMapping servletMapping : collection) {
                servletRegistration.addMapping(new String[]{servletMapping.urlPattern()});
            }
            for (InitParam initParam : servlet.initParams()) {
                servletRegistration.setInitParameter(initParam.name(), initParam.value());
            }
        }
        for (Filter filter : webAppConfig.filters()) {
            servletRegistration = this.appContext.addFilter(filter.filterName(), filter.filterClass());
            collection = webAppConfig.filterMappings(filter.filterName());
            for (FilterMapping filterMapping : collection) {
                String string = filterMapping.urlPattern();
                String string2 = filterMapping.servletName();
                if (string != null) {
                    servletRegistration.addMappingForUrlPatterns(null, new String[]{string});
                    continue;
                }
                servletRegistration.addMappingForServletNames(null, new String[]{string2});
            }
            for (InitParam initParam : filter.initParams()) {
                servletRegistration.setInitParameter(initParam.name(), initParam.value());
            }
        }
        this.appContext.deploy(this.server);
        logger.debug("started grizzly webserver endpoint at " + this.server.getHttpHandler().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void stop() {
        try {
            this.appContext.undeploy();
        }
        catch (Exception exception) {
            logger.warn(exception.getMessage(), (Throwable)exception);
        }
        finally {
            this.server.stop();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
    }
}

