/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.util;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.GraphStoreFactory;
import com.sun.jersey.api.uri.UriBuilderImpl;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.security.MessageDigest;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import javax.jcr.LoginException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.fcrepo.AbstractResource;
import org.fcrepo.Datastream;
import org.fcrepo.FedoraObject;
import org.fcrepo.identifiers.UUIDPidMinter;
import org.fcrepo.utils.ContentDigest;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.modeshape.jcr.api.NamespaceRegistry;
import org.modeshape.jcr.api.Repository;
import org.modeshape.jcr.api.query.QueryManager;

public abstract class TestHelpers {
    public static String MOCK_PREFIX = "mockPrefix";
    public static String MOCK_URI_STRING = "mock.namespace.org";

    public static UriInfo getUriInfoImpl() {
        UriInfo uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
        Answer<UriBuilder> answer = new Answer<UriBuilder>(){

            public UriBuilder answer(InvocationOnMock invocationOnMock) throws Throwable {
                UriBuilderImpl uriBuilderImpl = new UriBuilderImpl();
                uriBuilderImpl.scheme("http");
                uriBuilderImpl.host("localhost");
                uriBuilderImpl.path("/fcrepo");
                return uriBuilderImpl;
            }
        };
        Mockito.when((Object)uriInfo.getRequestUri()).thenReturn((Object)URI.create("http://localhost/fcrepo"));
        Mockito.when((Object)uriInfo.getBaseUri()).thenReturn((Object)URI.create("http://localhost/fcrepo"));
        Mockito.when((Object)uriInfo.getBaseUriBuilder()).thenAnswer((Answer)answer);
        Mockito.when((Object)uriInfo.getAbsolutePathBuilder()).thenAnswer((Answer)answer);
        return uriInfo;
    }

    public static Session getQuerySessionMock() {
        Query query;
        Session session = (Session)Mockito.mock(Session.class);
        Workspace workspace = (Workspace)Mockito.mock(Workspace.class);
        QueryManager queryManager = (QueryManager)Mockito.mock(QueryManager.class);
        try {
            query = TestHelpers.getQueryMock();
            Mockito.when((Object)queryManager.createQuery(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)query);
            Mockito.when((Object)workspace.getQueryManager()).thenReturn((Object)queryManager);
        }
        catch (RepositoryException repositoryException) {
            repositoryException.printStackTrace();
        }
        Mockito.when((Object)session.getWorkspace()).thenReturn((Object)workspace);
        query = (ValueFactory)Mockito.mock(ValueFactory.class);
        try {
            Mockito.when((Object)session.getValueFactory()).thenReturn((Object)query);
        }
        catch (RepositoryException repositoryException) {
            repositoryException.printStackTrace();
        }
        return session;
    }

    public static Query getQueryMock() {
        Query query = (Query)Mockito.mock(Query.class);
        QueryResult queryResult = (QueryResult)Mockito.mock(QueryResult.class);
        NodeIterator nodeIterator = (NodeIterator)Mockito.mock(NodeIterator.class);
        Mockito.when((Object)nodeIterator.getSize()).thenReturn((Object)2L);
        Mockito.when((Object)nodeIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Node node = (Node)Mockito.mock(Node.class);
        Node node2 = (Node)Mockito.mock(Node.class);
        try {
            Mockito.when((Object)node.getName()).thenReturn((Object)"node1");
            Mockito.when((Object)node2.getName()).thenReturn((Object)"node2");
        }
        catch (RepositoryException repositoryException) {
            repositoryException.printStackTrace();
        }
        Mockito.when((Object)nodeIterator.nextNode()).thenReturn((Object)node, (Object[])new Node[]{node2}).thenThrow(new Class[]{IndexOutOfBoundsException.class});
        try {
            Mockito.when((Object)queryResult.getNodes()).thenReturn((Object)nodeIterator);
            Mockito.when((Object)query.execute()).thenReturn((Object)queryResult);
        }
        catch (RepositoryException repositoryException) {
            repositoryException.printStackTrace();
        }
        return query;
    }

    public static Session getSessionMock() throws RepositoryException {
        String[] stringArray = new String[]{MOCK_PREFIX};
        Session session = (Session)Mockito.mock(Session.class);
        Workspace workspace = (Workspace)Mockito.mock(Workspace.class);
        NamespaceRegistry namespaceRegistry = (NamespaceRegistry)Mockito.mock(NamespaceRegistry.class);
        NodeTypeManager nodeTypeManager = (NodeTypeManager)Mockito.mock(NodeTypeManager.class);
        NodeTypeIterator nodeTypeIterator = (NodeTypeIterator)Mockito.mock(NodeTypeIterator.class);
        NodeType nodeType = (NodeType)Mockito.mock(NodeType.class);
        Mockito.when((Object)session.getWorkspace()).thenReturn((Object)workspace);
        Mockito.when((Object)workspace.getNamespaceRegistry()).thenReturn((Object)namespaceRegistry);
        Mockito.when((Object)namespaceRegistry.getPrefixes()).thenReturn((Object)stringArray);
        Mockito.when((Object)namespaceRegistry.getURI(MOCK_PREFIX)).thenReturn((Object)MOCK_URI_STRING);
        Mockito.when((Object)workspace.getNodeTypeManager()).thenReturn((Object)nodeTypeManager);
        Mockito.when((Object)nodeType.getName()).thenReturn((Object)"mockName");
        Mockito.when((Object)nodeType.toString()).thenReturn((Object)"mockString");
        Mockito.when((Object)nodeTypeManager.getAllNodeTypes()).thenReturn((Object)nodeTypeIterator);
        Mockito.when((Object)nodeTypeIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)nodeTypeIterator.nextNodeType()).thenReturn((Object)nodeType).thenThrow(new Class[]{ArrayIndexOutOfBoundsException.class});
        return session;
    }

    public static Collection<String> parseChildren(HttpEntity httpEntity) throws IOException {
        String string = EntityUtils.toString((HttpEntity)httpEntity);
        System.err.println(string);
        String[] stringArray = string.replace("[", "").replace("]", "").trim().split(",\\s?");
        return Arrays.asList(stringArray);
    }

    public static Session mockSession(AbstractResource abstractResource) throws RepositoryException, NoSuchFieldException {
        SecurityContext securityContext = (SecurityContext)Mockito.mock(SecurityContext.class);
        Principal principal = (Principal)Mockito.mock(Principal.class);
        Session session = (Session)Mockito.mock(Session.class);
        Mockito.when((Object)session.getUserID()).thenReturn((Object)"testuser");
        Mockito.when((Object)securityContext.getUserPrincipal()).thenReturn((Object)principal);
        Mockito.when((Object)principal.getName()).thenReturn((Object)"testuser");
        TestHelpers.setField(abstractResource, "uriInfo", TestHelpers.getUriInfoImpl());
        TestHelpers.setField(abstractResource, "pidMinter", new UUIDPidMinter());
        return session;
    }

    public static Repository mockRepository() throws LoginException, RepositoryException {
        Repository repository = (Repository)Mockito.mock(Repository.class);
        Session session = (Session)Mockito.mock(Session.class);
        Mockito.when((Object)repository.login()).thenReturn((Object)session);
        return repository;
    }

    public static Datastream mockDatastream(String string, String string2, String string3) {
        Datastream datastream = (Datastream)Mockito.mock(Datastream.class);
        FedoraObject fedoraObject = (FedoraObject)Mockito.mock(FedoraObject.class);
        try {
            Mockito.when((Object)fedoraObject.getName()).thenReturn((Object)string);
            Mockito.when((Object)datastream.getPath()).thenReturn((Object)("/" + string + "/" + string2));
            Mockito.when((Object)datastream.getObject()).thenReturn((Object)fedoraObject);
            Mockito.when((Object)datastream.getDsId()).thenReturn((Object)string2);
            Mockito.when((Object)datastream.getMimeType()).thenReturn((Object)"application/octet-stream");
            Mockito.when((Object)datastream.getCreatedDate()).thenReturn((Object)new Date());
            Mockito.when((Object)datastream.getLastModifiedDate()).thenReturn((Object)new Date());
            if (string3 != null) {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
                byte[] byArray = messageDigest.digest(string3.getBytes());
                URI uRI = ContentDigest.asURI((String)"SHA-1", (byte[])byArray);
                Mockito.when((Object)datastream.getContent()).thenReturn((Object)IOUtils.toInputStream((String)string3));
                Mockito.when((Object)datastream.getContentDigest()).thenReturn((Object)uRI);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return datastream;
    }

    public static GraphStore parseTriples(InputStream inputStream) {
        Model model = ModelFactory.createDefaultModel();
        model.read(inputStream, "", "N3");
        return GraphStoreFactory.create((Model)model);
    }

    public static void setField(Object object, String string, Object object2) throws NoSuchFieldException {
        try {
            Field field = TestHelpers.findField(object.getClass(), string);
            field.setAccessible(true);
            field.set(object, object2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static Field findField(Class<?> clazz, String string) throws NoSuchFieldException {
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.getName().equals(string)) continue;
            return field;
        }
        if (clazz.getSuperclass() == null) {
            throw new NoSuchFieldException("Field " + string + " could not be found");
        }
        return TestHelpers.findField(clazz.getSuperclass(), string);
    }
}

