/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.webxml;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import org.fcrepo.webxml.bind.ContextParam;
import org.fcrepo.webxml.bind.Displayable;
import org.fcrepo.webxml.bind.Filter;
import org.fcrepo.webxml.bind.FilterMapping;
import org.fcrepo.webxml.bind.Listener;
import org.fcrepo.webxml.bind.Servlet;
import org.fcrepo.webxml.bind.ServletMapping;

@XmlRootElement(namespace="http://java.sun.com/xml/ns/javaee", name="web-app")
public class WebAppConfig
extends Displayable {
    @XmlElements(value={@XmlElement(namespace="http://java.sun.com/xml/ns/javaee", name="context-param")})
    List<ContextParam> contextParams;
    @XmlElements(value={@XmlElement(namespace="http://java.sun.com/xml/ns/javaee", name="listener")})
    List<Listener> listeners;
    @XmlElements(value={@XmlElement(namespace="http://java.sun.com/xml/ns/javaee", name="servlet")})
    List<Servlet> servlets;
    @XmlElements(value={@XmlElement(namespace="http://java.sun.com/xml/ns/javaee", name="filter")})
    List<Filter> filters;
    @XmlElements(value={@XmlElement(namespace="http://java.sun.com/xml/ns/javaee", name="servlet-mapping")})
    List<ServletMapping> servletMappings;
    @XmlElements(value={@XmlElement(namespace="http://java.sun.com/xml/ns/javaee", name="filter-mapping")})
    List<FilterMapping> filterMappings;
    private static List<ContextParam> NO_CP = Collections.unmodifiableList(new ArrayList(0));
    private static List<Servlet> NO_S = Collections.unmodifiableList(new ArrayList(0));
    private static List<Filter> NO_F = Collections.unmodifiableList(new ArrayList(0));
    private static List<Listener> NO_L = Collections.unmodifiableList(new ArrayList(0));

    public Collection<ServletMapping> servletMappings(String string) {
        return Collections2.filter(this.servletMappings, (Predicate)new SMapFilter(string));
    }

    public Collection<FilterMapping> filterMappings(String string) {
        return Collections2.filter(this.filterMappings, (Predicate)new FMapFilter(string));
    }

    public Collection<ContextParam> contextParams() {
        return this.contextParams != null ? this.contextParams : NO_CP;
    }

    public Collection<Servlet> servlets() {
        return this.servlets != null ? this.servlets : NO_S;
    }

    public Collection<Filter> filters() {
        return this.filters != null ? this.filters : NO_F;
    }

    public Collection<Listener> listeners() {
        return this.listeners != null ? this.listeners : NO_L;
    }

    private static class FMapFilter
    implements Predicate<FilterMapping> {
        String filterName;

        FMapFilter(String string) {
            this.filterName = string;
        }

        public boolean apply(FilterMapping filterMapping) {
            return this.filterName == null ? filterMapping.filterName() == null : this.filterName.equals(filterMapping.filterName());
        }
    }

    private static class SMapFilter
    implements Predicate<ServletMapping> {
        String servletName;

        SMapFilter(String string) {
            this.servletName = string;
        }

        public boolean apply(ServletMapping servletMapping) {
            return this.servletName == null ? servletMapping.servletName() == null : this.servletName.equals(servletMapping.servletName());
        }
    }
}

