/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo;

import com.google.common.eventbus.EventBus;
import com.hp.hpl.jena.query.Dataset;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.io.IOUtils;
import org.fcrepo.Datastream;
import org.fcrepo.FedoraResource;
import org.fcrepo.api.rdf.HttpGraphSubjects;
import org.fcrepo.api.rdf.HttpTripleUtil;
import org.fcrepo.exception.InvalidChecksumException;
import org.fcrepo.identifiers.PidMinter;
import org.fcrepo.rdf.GraphSubjects;
import org.fcrepo.services.DatastreamService;
import org.fcrepo.services.NodeService;
import org.fcrepo.services.ObjectService;
import org.fcrepo.session.SessionFactory;
import org.modeshape.jcr.api.JcrTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractResource.class);
    @Context
    protected UriInfo uriInfo;
    @Autowired
    protected SessionFactory sessions;
    @Autowired
    protected NodeService nodeService;
    @Autowired
    protected ObjectService objectService;
    @Autowired
    protected DatastreamService datastreamService;
    @Autowired(required=false)
    private HttpTripleUtil httpTripleUtil;
    @Autowired(required=false)
    protected EventBus eventBus;
    @Autowired
    protected PidMinter pidMinter;
    @Context
    private HttpServletRequest servletRequest;
    @Context
    private SecurityContext securityContext;
    protected static final JcrTools jcrTools = new JcrTools(true);

    @PostConstruct
    public void initialize() throws RepositoryException {
    }

    public static final String toPath(List<PathSegment> list) {
        StringBuffer stringBuffer = new StringBuffer();
        LOGGER.trace("converting URI path to JCR path: {}", list);
        int n = 0;
        for (PathSegment pathSegment : list) {
            String string = pathSegment.getPath();
            if (string.equals("")) {
                LOGGER.trace("Ignoring empty segment {}", (Object)string);
                continue;
            }
            if (n == 0 && (string.startsWith("tx:") || string.startsWith("workspace:"))) {
                LOGGER.trace("Ignoring internal segment {}", (Object)string);
                ++n;
                continue;
            }
            LOGGER.trace("Adding segment {}", (Object)string);
            if (!string.startsWith("[")) {
                stringBuffer.append('/');
            }
            stringBuffer.append(string);
            ++n;
        }
        String string = stringBuffer.toString();
        if (string.isEmpty()) {
            return "/";
        }
        return string;
    }

    protected FedoraResource createObjectOrDatastreamFromRequestContent(Class<?> clazz, Session session, String string, String string2, UriInfo uriInfo, InputStream inputStream, MediaType mediaType, URI uRI) throws RepositoryException, InvalidChecksumException, IOException {
        FedoraResource fedoraResource;
        switch (string2) {
            case "fedora:object": {
                fedoraResource = this.objectService.createObject(session, string);
                if (inputStream == null || mediaType == null || !mediaType.toString().equals("application/sparql-update")) break;
                fedoraResource.updatePropertiesDataset(new HttpGraphSubjects(clazz, uriInfo), IOUtils.toString((InputStream)inputStream));
                break;
            }
            case "fedora:datastream": {
                MediaType mediaType2 = mediaType != null ? mediaType : MediaType.APPLICATION_OCTET_STREAM_TYPE;
                Node node = this.datastreamService.createDatastreamNode(session, string, mediaType2.toString(), inputStream, uRI);
                fedoraResource = new Datastream(node);
                break;
            }
            default: {
                fedoraResource = null;
            }
        }
        return fedoraResource;
    }

    protected void addResponseInformationToDataset(FedoraResource fedoraResource, Dataset dataset, UriInfo uriInfo, GraphSubjects graphSubjects) throws RepositoryException {
        if (this.httpTripleUtil != null) {
            this.httpTripleUtil.addHttpComponentModelsForResource(dataset, fedoraResource, uriInfo, graphSubjects);
        }
    }
}

