/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.FedoraObject;
import org.fcrepo.FedoraResource;
import org.fcrepo.binary.PolicyDecisionPoint;
import org.fcrepo.exception.InvalidChecksumException;
import org.fcrepo.metrics.RegistryService;
import org.fcrepo.services.ServiceHelpers;
import org.fcrepo.utils.ContentDigest;
import org.fcrepo.utils.FedoraJcrTypes;
import org.fcrepo.utils.FedoraTypesUtils;
import org.modeshape.jcr.api.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Datastream
extends FedoraResource
implements FedoraJcrTypes {
    private static final Logger LOGGER = LoggerFactory.getLogger(Datastream.class);
    static final Histogram contentSizeHistogram = RegistryService.getMetrics().histogram(MetricRegistry.name(Datastream.class, (String[])new String[]{"content-size"}));

    public Datastream(Node node) {
        super(node);
    }

    public Datastream(Session session, String string, String string2) throws RepositoryException {
        super(session, string, string2);
        this.mixinTypeSpecificCrap();
    }

    public Datastream(Session session, String string) throws RepositoryException {
        this(session, string, "nt:file");
    }

    private void mixinTypeSpecificCrap() {
        try {
            if (this.node.isNew() || !Datastream.hasMixin(this.node)) {
                LOGGER.debug("Setting {} properties on a {} node...", (Object)"fedora:datastream", (Object)"nt:file");
                this.node.addMixin("fedora:datastream");
                if (this.node.hasNode("jcr:content")) {
                    Node node = this.node.getNode("jcr:content");
                    this.decorateContentNode(node);
                }
            }
        }
        catch (RepositoryException repositoryException) {
            LOGGER.warn("Could not decorate {} with {} properties: {}", new Object[]{"jcr:content", "fedora:datastream", repositoryException});
        }
    }

    public InputStream getContent() throws RepositoryException {
        Node node = this.node.getNode("jcr:content");
        LOGGER.trace("Retrieved datastream content node.");
        return node.getProperty("jcr:data").getBinary().getStream();
    }

    public void setContent(InputStream inputStream, String string, URI uRI, PolicyDecisionPoint policyDecisionPoint) throws RepositoryException, InvalidChecksumException {
        Node node = this.findOrCreateChild(this.node, "jcr:content", "nt:resource");
        if (node.canAddMixin("fedora:binary")) {
            node.addMixin("fedora:binary");
        }
        if (string != null) {
            node.setProperty("jcr:mimeType", string);
        }
        LOGGER.debug("Created content node at path: {}", (Object)node.getPath());
        String string2 = null;
        if (policyDecisionPoint != null) {
            string2 = policyDecisionPoint.evaluatePolicies(this.node);
        }
        Binary binary = (Binary)FedoraTypesUtils.getBinary((Node)this.node, (InputStream)inputStream, (String)string2);
        Property property = node.setProperty("jcr:data", (javax.jcr.Binary)binary);
        String string3 = binary.getHexHash();
        if (uRI != null && !uRI.equals(ContentDigest.asURI((String)"SHA-1", (String)string3))) {
            LOGGER.debug("Failed checksum test");
            throw new InvalidChecksumException("Checksum Mismatch of " + string3 + " and " + uRI);
        }
        this.decorateContentNode(node);
        LOGGER.debug("Created data property at path: {}", (Object)property.getPath());
    }

    public void setContent(InputStream inputStream) throws InvalidChecksumException, RepositoryException {
        this.setContent(inputStream, null, null, null);
    }

    public long getContentSize() {
        try {
            return this.node.getNode("jcr:content").getProperty("fedora:size").getLong();
        }
        catch (RepositoryException repositoryException) {
            LOGGER.error("Could not get contentSize() - " + repositoryException.getMessage());
            return 0L;
        }
    }

    public URI getContentDigest() throws RepositoryException {
        Node node = this.node.getNode("jcr:content");
        try {
            return new URI(node.getProperty("fedora:digest").getString());
        }
        catch (RepositoryException repositoryException) {
            LOGGER.error("Could not get content digest: ", (Throwable)repositoryException);
        }
        catch (URISyntaxException uRISyntaxException) {
            LOGGER.error("Could not get content digest: {}", (Throwable)uRISyntaxException);
        }
        Binary binary = (Binary)node.getProperty("jcr:data").getBinary();
        String string = binary.getHexHash();
        return ContentDigest.asURI((String)"SHA-1", (String)string);
    }

    public String getDsId() throws RepositoryException {
        return this.node.getName();
    }

    public FedoraObject getObject() throws RepositoryException {
        return new FedoraObject(this.node.getParent());
    }

    public String getMimeType() throws RepositoryException {
        return this.node.hasNode("jcr:content") && this.node.getNode("jcr:content").hasProperty("jcr:mimeType") ? this.node.getNode("jcr:content").getProperty("jcr:mimeType").getString() : "application/octet-stream";
    }

    @Override
    public long getSize() throws RepositoryException {
        return ServiceHelpers.getNodePropertySize((Node)this.node) + this.getContentSize();
    }

    private void decorateContentNode(Node node) throws RepositoryException {
        if (node == null) {
            LOGGER.warn("{}/{} appears to be null!", (Object)"jcr:content");
            return;
        }
        if (node.canAddMixin("fedora:binary")) {
            node.addMixin("fedora:binary");
        }
        Property property = node.getProperty("jcr:data");
        Binary binary = (Binary)property.getBinary();
        String string = binary.getHexHash();
        contentSizeHistogram.update(property.getLength());
        node.setProperty("fedora:size", property.getLength());
        node.setProperty("fedora:digest", ContentDigest.asURI((String)"SHA-1", (String)string).toString());
        LOGGER.debug("Decorated data property at path: " + property.getPath());
    }

    public static boolean hasMixin(Node node) throws RepositoryException {
        return FedoraTypesUtils.isFedoraDatastream.apply((Object)node);
    }
}

